/*
 * Decompiled with CFR 0.152.
 */
package de.regnis.q.sequence.media;

import de.regnis.q.sequence.core.QSequenceException;
import de.regnis.q.sequence.media.QSequenceCachableMedia;
import de.regnis.q.sequence.media.QSequenceCachableMediaGetter;
import java.util.HashMap;
import java.util.Map;

public class QSequenceCachingMediaSymbolMap {
    private final Map map;
    private int symbolCount;

    public QSequenceCachingMediaSymbolMap(int maximumSize) {
        this.map = new HashMap(maximumSize);
        this.symbolCount = 0;
    }

    public int getSymbolCount() {
        return this.symbolCount;
    }

    public int[] createSymbols(QSequenceCachableMedia media, QSequenceCachableMediaGetter mediaGetter) throws QSequenceException {
        int length = mediaGetter.getMediaLength(media);
        int[] symbols = new int[length];
        for (int index = 0; index < length; ++index) {
            Object object = mediaGetter.getMediaObject(media, index);
            symbols[index] = this.getSymbol(object);
        }
        return symbols;
    }

    private int getSymbol(Object obj) {
        Integer symbol = (Integer)this.map.get(obj);
        if (symbol == null) {
            symbol = new Integer(this.symbolCount);
            ++this.symbolCount;
            this.map.put(obj, symbol);
        }
        return symbol;
    }
}

