/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.filters;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.htmlparser.Node;
import org.htmlparser.NodeFilter;
import org.htmlparser.tags.LinkTag;

public class LinkRegexFilter
implements NodeFilter {
    protected Pattern mRegex;

    public LinkRegexFilter(String regexPattern) {
        this(regexPattern, true);
    }

    public LinkRegexFilter(String regexPattern, boolean caseSensitive) {
        this.mRegex = caseSensitive ? Pattern.compile(regexPattern) : Pattern.compile(regexPattern, 2);
    }

    public boolean accept(Node node) {
        boolean ret = false;
        if (LinkTag.class.isAssignableFrom(node.getClass())) {
            String link = ((LinkTag)node).getLink();
            Matcher matcher = this.mRegex.matcher(link);
            ret = matcher.find();
        }
        return ret;
    }
}

