/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.dictionaries;

import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.omegat.core.dictionaries.DictionaryData;
import org.omegat.core.dictionaries.DictionaryEntry;
import org.omegat.core.dictionaries.IDictionary;
import org.omegat.core.dictionaries.IDictionaryFactory;
import org.omegat.util.Language;

public class LingvoDSL
implements IDictionaryFactory {
    protected static final Pattern RE_SKIP = Pattern.compile("\\[.+?\\]");
    protected static final String[] EMPTY_RESULT = new String[0];

    @Override
    public boolean isSupportedFile(File file) {
        return file.getPath().endsWith(".dsl");
    }

    @Override
    public IDictionary loadDict(File file) throws Exception {
        return this.loadDict(file, new Language(Locale.getDefault()));
    }

    @Override
    public IDictionary loadDict(File file, Language language) throws Exception {
        return new LingvoDSLDict(LingvoDSL.loadData(file, language));
    }

    private static DictionaryData<String> loadData(File file, Language language) throws Exception {
        DictionaryData<String> data = new DictionaryData<String>(language);
        StringBuilder word = new StringBuilder();
        StringBuilder trans = new StringBuilder();
        Files.lines(file.toPath(), StandardCharsets.UTF_16).filter(line -> !line.isEmpty() && !line.startsWith("#")).map(line -> RE_SKIP.matcher((CharSequence)line).replaceAll("")).forEach(line -> {
            if (Character.isWhitespace(line.codePointAt(0))) {
                trans.append(line.trim()).append('\n');
            } else {
                if (word.length() > 0) {
                    data.add(word.toString(), trans.toString());
                    word.setLength(0);
                    trans.setLength(0);
                }
                word.append((String)line);
            }
        });
        if (word.length() > 0) {
            data.add(word.toString(), trans.toString());
        }
        data.done();
        return data;
    }

    static class LingvoDSLDict
    implements IDictionary {
        protected final DictionaryData<String> data;

        LingvoDSLDict(DictionaryData<String> data) throws Exception {
            this.data = data;
        }

        @Override
        public List<DictionaryEntry> readArticles(String word) throws Exception {
            return this.data.lookUp(word).stream().map(e -> new DictionaryEntry((String)e.getKey(), (String)e.getValue())).collect(Collectors.toList());
        }

        @Override
        public List<DictionaryEntry> readArticlesPredictive(String word) throws Exception {
            return this.data.lookUpPredictive(word).stream().map(e -> new DictionaryEntry((String)e.getKey(), (String)e.getValue())).collect(Collectors.toList());
        }
    }
}

