/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.data;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.madlonkay.supertmxmerge.data.ITmx;
import org.madlonkay.supertmxmerge.data.ITu;
import org.madlonkay.supertmxmerge.data.ITuv;
import org.madlonkay.supertmxmerge.data.Key;
import org.madlonkay.supertmxmerge.data.ResolutionSet;
import org.madlonkay.supertmxmerge.data.WriteFailedException;
import org.madlonkay.supertmxmerge.util.ReflectionUtil;
import org.omegat.core.data.EntryKey;
import org.omegat.core.data.ProjectTMX;
import org.omegat.core.data.TMXEntry;

public final class SyncTMX
implements ITmx {
    private ProjectTMX tmx;
    private final String name;
    private final String sourceLanguage;
    private final String targetLanguage;
    private Map<Key, ITu> tuMap;
    private Map<Key, ITuv> tuvMap;

    public SyncTMX(ProjectTMX tmx, String name, String sourceLanguage, String targetLanguage) {
        this.tmx = tmx;
        this.name = name;
        this.sourceLanguage = sourceLanguage;
        this.targetLanguage = targetLanguage;
        this.generateMaps();
    }

    private void generateMaps() {
        Key key;
        SyncTu tu;
        this.tuvMap = new HashMap<Key, ITuv>();
        this.tuMap = new HashMap<Key, ITu>();
        for (Map.Entry<String, TMXEntry> entry : this.tmx.defaults.entrySet()) {
            tu = new SyncTu(entry.getValue(), this.targetLanguage);
            key = this.makeKey(entry.getKey(), entry.getValue());
            assert (!this.tuMap.containsKey(key));
            assert (!this.tuvMap.containsKey(key));
            this.tuMap.put(key, tu);
            this.tuvMap.put(key, tu.getTargetTuv());
        }
        for (Map.Entry<Object, TMXEntry> entry : this.tmx.alternatives.entrySet()) {
            tu = new SyncTu(entry.getValue(), this.targetLanguage);
            key = this.makeKey(entry.getKey(), entry.getValue());
            assert (!this.tuMap.containsKey(key));
            assert (!this.tuvMap.containsKey(key));
            this.tuMap.put(key, tu);
            this.tuvMap.put(key, tu.getTargetTuv());
        }
    }

    private Key makeKey(Object entryKey, TMXEntry tmxEntry) {
        Key key = new Key(tmxEntry.source, entryKey);
        if (entryKey instanceof EntryKey) {
            EntryKey ek = (EntryKey)entryKey;
            key.addProp("file", ek.file);
            key.addProp("id", ek.id);
            key.addProp("next", ek.next);
            key.addProp("path", ek.path);
            key.addProp("prev", ek.prev);
        }
        return key;
    }

    public String getSourceLanguage() {
        return this.sourceLanguage;
    }

    public String getName() {
        return this.name;
    }

    public int getSize() {
        return this.tmx.alternatives.size() + this.tmx.defaults.size();
    }

    public Map<String, String> getMetadata() {
        return Collections.emptyMap();
    }

    public ITmx applyChanges(ResolutionSet resolution) {
        ProjectTMX originalData = SyncTMX.clone(this.tmx);
        for (Key key : resolution.toDelete) {
            this.remove(key);
        }
        for (Map.Entry entry : resolution.toReplace.entrySet()) {
            this.remove((Key)entry.getKey());
            this.add((Key)entry.getKey(), (TMXEntry)((ITuv)entry.getValue()).getUnderlyingRepresentation());
        }
        for (Map.Entry entry : resolution.toAdd.entrySet()) {
            this.add((Key)entry.getKey(), (TMXEntry)((ITu)entry.getValue()).getUnderlyingRepresentation());
        }
        ProjectTMX modifiedData = this.tmx;
        this.tmx = originalData;
        this.tuvMap = null;
        this.tuMap = null;
        return new SyncTMX(modifiedData, this.name, this.sourceLanguage, this.targetLanguage);
    }

    private void add(Key key, TMXEntry tuv) {
        if (key.foreignKey instanceof String) {
            this.tmx.defaults.put((String)key.foreignKey, tuv);
        } else if (key.foreignKey instanceof EntryKey) {
            this.tmx.alternatives.put((EntryKey)key.foreignKey, tuv);
        } else {
            throw new IllegalArgumentException("Cannot add key of type " + key.getClass().getName() + " to a " + this.getClass().getName());
        }
    }

    private void remove(Key key) {
        if (key.foreignKey instanceof String) {
            this.tmx.defaults.remove((String)key.foreignKey);
        } else if (key.foreignKey instanceof EntryKey) {
            this.tmx.alternatives.remove((EntryKey)key.foreignKey);
        } else {
            throw new IllegalArgumentException("Cannot remove key of type " + key.getClass().getName() + " from a " + this.getClass().getName());
        }
    }

    private static ProjectTMX clone(ProjectTMX tmx) {
        ProjectTMX newTmx = new ProjectTMX();
        for (Map.Entry<EntryKey, TMXEntry> entry : tmx.alternatives.entrySet()) {
            newTmx.alternatives.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<Object, TMXEntry> entry : tmx.defaults.entrySet()) {
            newTmx.defaults.put((String)entry.getKey(), entry.getValue());
        }
        return newTmx;
    }

    public void writeTo(File outputFile) throws WriteFailedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Object getUnderlyingRepresentation() {
        return this.tmx;
    }

    public ITu getTu(Key key) {
        return this.tuMap.get(key);
    }

    public int size() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isEmpty() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean containsKey(Object key) {
        return this.tuvMap.containsKey(key);
    }

    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ITuv get(Object key) {
        return this.tuvMap.get(key);
    }

    public ITuv put(Key key, ITuv value) {
        return this.tuvMap.put(key, value);
    }

    public ITuv remove(Object key) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void putAll(Map<? extends Key, ? extends ITuv> m) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void clear() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Set<Key> keySet() {
        return this.tuvMap.keySet();
    }

    public Collection<ITuv> values() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Set<Map.Entry<Key, ITuv>> entrySet() {
        return this.tuvMap.entrySet();
    }

    private static class SyncTuv
    implements ITuv {
        private final TMXEntry tmxEntry;
        private final String language;
        private Map<String, String> props;

        SyncTuv(TMXEntry tmxEntry, String language) {
            this.tmxEntry = tmxEntry;
            this.language = language;
        }

        public String getContent() {
            return this.tmxEntry.translation;
        }

        public Map<String, String> getMetadata() {
            if (this.props == null) {
                this.props = Collections.unmodifiableMap(ReflectionUtil.simpleMembersToMap((Object)this.tmxEntry));
            }
            return this.props;
        }

        public String getLanguage() {
            return this.language;
        }

        public Object getUnderlyingRepresentation() {
            return this.tmxEntry;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SyncTuv other = (SyncTuv)obj;
            return this.tmxEntry.equals(other.tmxEntry) && this.language.equals(other.language);
        }

        public int hashCode() {
            int hash = 5;
            hash = 89 * hash + (this.tmxEntry != null ? this.tmxEntry.hashCode() : 0);
            hash = 89 * hash + (this.language != null ? this.language.hashCode() : 0);
            return hash;
        }

        public boolean equivalentTo(ITuv o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof SyncTuv)) {
                throw new IllegalArgumentException("Cannot check equivalence between SyncTuv and non-SyncTuv");
            }
            SyncTuv other = (SyncTuv)o;
            return this.tmxEntry.equalsTranslation(other.tmxEntry);
        }
    }

    private static class SyncTu
    implements ITu {
        private final TMXEntry tmxEntry;
        private final String targetLanguage;

        SyncTu(TMXEntry tmxEntry, String targetLanguage) {
            this.tmxEntry = tmxEntry;
            this.targetLanguage = targetLanguage;
        }

        public ITuv getTargetTuv() {
            return new SyncTuv(this.tmxEntry, this.targetLanguage);
        }

        public Object getUnderlyingRepresentation() {
            return this.tmxEntry;
        }
    }
}

