/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters2.po;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.omegat.util.OStrings;
import org.omegat.util.gui.StaticUIUtils;
import org.openide.awt.Mnemonics;

public class PoOptionsDialog
extends JDialog {
    public static final int RET_CANCEL = 0;
    public static final int RET_OK = 1;
    private final Map<String, String> options;
    private JCheckBox allowBlankCB;
    private JCheckBox allowEditingBlankSegmentCB;
    private JCheckBox autoFillInPluralStatementCB;
    private ButtonGroup buttonGroup1;
    private JPanel buttonPanel;
    private JButton cancelButton;
    private JRadioButton formatMonolingualRB;
    private JRadioButton formatStandardRB;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JButton okButton;
    private JCheckBox skipHeaderCB;
    private int returnStatus = 0;

    public PoOptionsDialog(Window parent, Map<String, String> options) {
        super(parent);
        this.setModal(true);
        this.options = new TreeMap<String, String>(options);
        this.initComponents();
        String allowBlank = options.get("disallowBlank");
        this.allowBlankCB.setSelected("true".equalsIgnoreCase(allowBlank));
        String allowEditingBlankSegment = options.get("disallowEditingBlankSegment");
        this.allowEditingBlankSegmentCB.setSelected("true".equalsIgnoreCase(allowEditingBlankSegment));
        String skipHeader = options.get("skipHeader");
        this.skipHeaderCB.setSelected("true".equalsIgnoreCase(skipHeader));
        String autoFillInPluralStatement = options.get("autoFillInPluralStatement");
        this.autoFillInPluralStatementCB.setSelected("true".equalsIgnoreCase(autoFillInPluralStatement));
        if ("true".equalsIgnoreCase(options.get("monolingualFormat"))) {
            this.formatMonolingualRB.setSelected(true);
        } else {
            this.formatStandardRB.setSelected(true);
        }
        StaticUIUtils.setEscapeAction(this, (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PoOptionsDialog.this.doClose(0);
            }
        });
        this.setLocationRelativeTo(parent);
    }

    public int getReturnStatus() {
        return this.returnStatus;
    }

    public Map<String, String> getOptions() {
        return this.options;
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.buttonPanel = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.jPanel1 = new JPanel();
        this.allowBlankCB = new JCheckBox();
        this.skipHeaderCB = new JCheckBox();
        this.autoFillInPluralStatementCB = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.formatStandardRB = new JRadioButton();
        this.formatMonolingualRB = new JRadioButton();
        this.allowEditingBlankSegmentCB = new JCheckBox();
        this.setTitle(OStrings.getString("POFILTER_OPTIONS_TITLE"));
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                PoOptionsDialog.this.closeDialog(evt);
            }
        });
        this.buttonPanel.setLayout(new FlowLayout(2));
        Mnemonics.setLocalizedText((AbstractButton)this.okButton, (String)OStrings.getString("BUTTON_OK"));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PoOptionsDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.okButton);
        Mnemonics.setLocalizedText((AbstractButton)this.cancelButton, (String)OStrings.getString("BUTTON_CANCEL"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PoOptionsDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.cancelButton);
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.jPanel1.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.jPanel1.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.allowBlankCB, (String)OStrings.getString("POFILTER_ALLOW_BLANK"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.allowBlankCB, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.skipHeaderCB, (String)OStrings.getString("POFILTER_SKIP_HEADER"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.skipHeaderCB, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.autoFillInPluralStatementCB, (String)OStrings.getString("POFILTER_AUTO_FILL_IN_PLURAL_STATEMENT"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.autoFillInPluralStatementCB, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)OStrings.getString("POFILTER_FORMAT_LABEL"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        this.buttonGroup1.add(this.formatStandardRB);
        Mnemonics.setLocalizedText((AbstractButton)this.formatStandardRB, (String)OStrings.getString("POFILTER_FORMAT_STANDARD"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.formatStandardRB, gridBagConstraints);
        this.buttonGroup1.add(this.formatMonolingualRB);
        Mnemonics.setLocalizedText((AbstractButton)this.formatMonolingualRB, (String)OStrings.getString("POFILTER_FORMAT_MONOLINGUAL"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.formatMonolingualRB, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.allowEditingBlankSegmentCB, (String)OStrings.getString("POFILTER_ALLOW_BLANK_SEGMENT"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.allowEditingBlankSegmentCB, gridBagConstraints);
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.options.put("disallowBlank", Boolean.toString(this.allowBlankCB.isSelected()));
        this.options.put("disallowEditingBlankSegment", Boolean.toString(this.allowEditingBlankSegmentCB.isSelected()));
        this.options.put("skipHeader", Boolean.toString(this.skipHeaderCB.isSelected()));
        this.options.put("autoFillInPluralStatement", Boolean.toString(this.autoFillInPluralStatementCB.isSelected()));
        this.options.put("monolingualFormat", Boolean.toString(this.formatMonolingualRB.isSelected()));
        this.doClose(1);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.doClose(0);
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose(0);
    }

    private void doClose(int retStatus) {
        this.returnStatus = retStatus;
        this.setVisible(false);
        this.dispose();
    }
}

