/*
 * Decompiled with CFR 0.152.
 */
package org.trie4j.patricia;

import java.io.Serializable;
import java.util.Map;
import org.trie4j.MapTrie;
import org.trie4j.patricia.MapPatriciaTrieNode;
import org.trie4j.patricia.PatriciaTrie;
import org.trie4j.patricia.PatriciaTrieNode;
import org.trie4j.util.Pair;

public class MapPatriciaTrie<T>
extends PatriciaTrie
implements Serializable,
MapTrie<T> {
    private static final long serialVersionUID = 2165079531157534766L;

    @Override
    public MapPatriciaTrieNode<T> getRoot() {
        return (MapPatriciaTrieNode)super.getRoot();
    }

    @Override
    public T insert(String text, T value) {
        MapPatriciaTrieNode node = (MapPatriciaTrieNode)this.insert(this.getRoot(), text, 0);
        Object ret = node.getValue();
        node.setValue(value);
        return ret;
    }

    @Override
    public T get(String word) {
        PatriciaTrieNode node = this.getNode(word);
        if (node == null) {
            return null;
        }
        return ((MapPatriciaTrieNode)node).getValue();
    }

    @Override
    public T put(String word, T value) {
        PatriciaTrieNode node = this.getNode(word);
        if (node == null) {
            return null;
        }
        Object ret = ((MapPatriciaTrieNode)node).getValue();
        ((MapPatriciaTrieNode)node).setValue(value);
        return ret;
    }

    @Override
    public MapPatriciaTrieNode<T> getNode(String text) {
        return (MapPatriciaTrieNode)super.getNode(text);
    }

    @Override
    public Iterable<Map.Entry<String, T>> commonPrefixSearchEntries(String query) {
        return new IterableAdapter(this.commonPrefixSearchWithNode(query));
    }

    @Override
    public Iterable<Map.Entry<String, T>> predictiveSearchEntries(String prefix) {
        return new IterableAdapter(this.predictiveSearchWithNode(prefix));
    }

    @Override
    protected MapPatriciaTrieNode<T> newNode() {
        return new MapPatriciaTrieNode();
    }

    @Override
    protected PatriciaTrieNode newNode(char[] letters, PatriciaTrieNode source) {
        return new MapPatriciaTrieNode(letters, source.isTerminate(), (MapPatriciaTrieNode[])source.getChildren(), ((MapPatriciaTrieNode)source).getValue());
    }

    @Override
    protected MapPatriciaTrieNode<T> newNode(char[] letters, boolean terminated) {
        return new MapPatriciaTrieNode(letters, terminated);
    }

    protected MapPatriciaTrieNode<T>[] newNodeArray(PatriciaTrieNode ... nodes) {
        MapPatriciaTrieNode[] ret = new MapPatriciaTrieNode[nodes.length];
        System.arraycopy(nodes, 0, ret, 0, nodes.length);
        return ret;
    }

    private class IterableAdapter
    extends org.trie4j.util.IterableAdapter<Pair<String, PatriciaTrieNode>, Map.Entry<String, T>> {
        public IterableAdapter(Iterable<Pair<String, PatriciaTrieNode>> orig) {
            super(orig);
        }

        @Override
        protected Map.Entry<String, T> convert(Pair<String, PatriciaTrieNode> value) {
            return new Entry(value.getFirst(), (MapPatriciaTrieNode)value.getSecond());
        }
    }

    private class Entry
    implements Map.Entry<String, T> {
        private String key;
        private MapPatriciaTrieNode<T> node;

        public Entry(String key, MapPatriciaTrieNode<T> node) {
            this.key = key;
            this.node = node;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public T getValue() {
            return this.node.getValue();
        }

        @Override
        public T setValue(T value) {
            Object ret = this.node.getValue();
            this.node.setValue(value);
            return ret;
        }
    }
}

