/*
 * Decompiled with CFR 0.152.
 */
package net.loomchild.maligna.filter.modifier.modify.split;

import java.io.IOException;
import java.io.Reader;
import net.loomchild.maligna.util.IORuntimeException;
import net.loomchild.maligna.util.ImpossibleException;

public class SimpleSplitter {
    public static final char[] BREAK_CHARACTER_LIST = new char[]{'.', '!', '?'};
    private Reader reader;
    private State state;
    private StringBuilder builder;
    private String segment;

    public SimpleSplitter(Reader reader) {
        this.reader = reader;
        this.state = State.READY;
        this.builder = new StringBuilder();
        this.segment = null;
    }

    public String next() {
        if (this.hasNext()) {
            this.readSegment(true);
            String newSegment = this.segment;
            this.segment = null;
            return newSegment;
        }
        return null;
    }

    public boolean hasNext() {
        return this.state != State.END || this.segment != null;
    }

    public boolean isReady() {
        if (this.hasNext()) {
            return this.segment != null || this.readSegment(false);
        }
        return false;
    }

    private boolean readSegment(boolean canBlock) {
        try {
            if (this.segment != null) {
                return true;
            }
            int leftCharacters = 0;
            while (this.state != State.END) {
                if (!canBlock && !this.reader.ready()) {
                    return false;
                }
                int readResult = this.reader.read();
                if (readResult == -1) {
                    this.state = State.END;
                    leftCharacters = 0;
                    continue;
                }
                char character = (char)readResult;
                this.builder.append(character);
                if (character == '\n') {
                    this.state = State.READY;
                    leftCharacters = 0;
                    break;
                }
                if (this.state == State.READY) {
                    if (!this.isBreakCharacter(character)) continue;
                    this.state = State.AFTER_BREAK;
                    continue;
                }
                if (this.state == State.AFTER_BREAK) {
                    if (Character.isWhitespace(character)) {
                        ++leftCharacters;
                        this.state = State.AFTER_SPACE;
                        continue;
                    }
                    if (this.isBreakCharacter(character)) continue;
                    this.state = State.READY;
                    leftCharacters = 0;
                    continue;
                }
                if (this.state == State.AFTER_SPACE) {
                    if (Character.isUpperCase(character)) {
                        this.state = State.READY;
                        ++leftCharacters;
                        break;
                    }
                    if (this.isBreakCharacter(character)) {
                        this.state = State.AFTER_BREAK;
                        ++leftCharacters;
                        break;
                    }
                    if (Character.isWhitespace(character)) {
                        ++leftCharacters;
                        continue;
                    }
                    this.state = State.READY;
                    leftCharacters = 0;
                    continue;
                }
                throw new ImpossibleException("Impossible SimpleSplitter state.");
            }
            this.segment = this.separateString(leftCharacters);
            return true;
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    private String separateString(int leftCharacters) {
        String result = this.builder.substring(0, this.builder.length() - leftCharacters);
        this.builder.delete(0, this.builder.length() - leftCharacters);
        return result;
    }

    private boolean isBreakCharacter(char character) {
        for (char ch : BREAK_CHARACTER_LIST) {
            if (ch != character) continue;
            return true;
        }
        return false;
    }

    public static enum State {
        READY,
        AFTER_BREAK,
        AFTER_SPACE,
        END;

    }
}

