/*
 * Decompiled with CFR 0.152.
 */
package org.dts.spell.dictionary.myspell.wordmaps;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Iterator;
import org.dts.spell.dictionary.myspell.HEntry;
import org.dts.spell.dictionary.myspell.Utils;
import org.dts.spell.dictionary.myspell.wordmaps.WordMap;

public class IndexedFileWordMap
extends WordMap {
    private RandomAccessFile words;
    private File wordFile;
    private long[] indexes;
    private int nIndex;

    @Override
    public void init(int nEntries) throws IOException {
        this.wordFile = File.createTempFile("words", "dic");
        this.indexes = new long[nEntries];
        this.nIndex = 0;
        this.words = new RandomAccessFile(this.wordFile, "rw");
        this.wordFile.deleteOnExit();
    }

    @Override
    public void finish(int nEntries) throws IOException {
        Utils.heapSort(this.indexes, new Utils.IndexComparator(){

            @Override
            public boolean isLess(long index1, long index2) {
                return IndexedFileWordMap.this.getEntry(index1).compareTo(IndexedFileWordMap.this.getEntry(index2)) < 0;
            }

            @Override
            public boolean isGreater(long index1, long index2) {
                return IndexedFileWordMap.this.getEntry(index1).compareTo(IndexedFileWordMap.this.getEntry(index2)) > 0;
            }
        });
    }

    @Override
    public HEntry get(String word) {
        try {
            int index = Utils.binarySearch(word, this.indexes.length, new Utils.IndexSearcher<String>(){

                @Override
                public int compare(int index, String obj) {
                    return IndexedFileWordMap.this.getWord(index).compareTo(obj);
                }
            });
            if (index >= 0) {
                return this.getEntry(index);
            }
            return null;
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Override
    public void add(HEntry entry) throws IOException {
        this.indexes[this.nIndex] = this.words.length();
        ++this.nIndex;
        this.words.writeUTF(entry.word);
        this.words.writeUTF(entry.astr);
    }

    protected String getWord(int index) {
        try {
            this.words.seek(this.indexes[index]);
            return this.words.readUTF();
        }
        catch (IOException ex) {
            return null;
        }
    }

    protected HEntry getEntry(long position) {
        try {
            this.words.seek(position);
            return new HEntry(this.words.readUTF(), this.words.readUTF());
        }
        catch (IOException ex) {
            return null;
        }
    }

    protected HEntry getEntry(int index) {
        return this.getEntry(this.indexes[index]);
    }

    @Override
    public void addCustomWord(String word) throws IOException {
    }

    @Override
    public Iterator<HEntry> iterator() {
        return new Iterator<HEntry>(){
            private HEntry nextEntry;
            private int next = 0;

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public HEntry next() {
                ++this.next;
                return this.nextEntry;
            }

            @Override
            public boolean hasNext() {
                this.nextEntry = this.next < IndexedFileWordMap.this.indexes.length ? IndexedFileWordMap.this.getEntry(this.next) : null;
                return null != this.nextEntry;
            }
        };
    }
}

