/*
 * Decompiled with CFR 0.152.
 */
package org.madlonkay.supertmxmerge.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.madlonkay.supertmxmerge.data.DiffAnalysis;
import org.madlonkay.supertmxmerge.data.MergeAnalysis;

public class DiffUtil {
    public static <K, V> DiffAnalysis mapDiff(Map<K, V> before, Map<K, V> after) {
        HashSet<K> deleted = new HashSet<K>(before.keySet());
        deleted.removeAll(after.keySet());
        HashSet<K> added = new HashSet<K>(after.keySet());
        added.removeAll(before.keySet());
        HashSet<K> modified = new HashSet<K>();
        for (Map.Entry<K, V> e : before.entrySet()) {
            V newItem = after.get(e.getKey());
            if (newItem == null || e.getValue().equals(newItem)) continue;
            modified.add(e.getKey());
        }
        return new DiffAnalysis<K>(deleted, added, modified);
    }

    public static <K, V> MergeAnalysis<K, V> mapMerge(Map<K, V> base, Map<K, V> left, Map<K, V> right) {
        V baseItem;
        V rightItem;
        V leftItem;
        HashSet toDelete = new HashSet();
        HashSet toAdd = new HashSet();
        HashMap toReplace = new HashMap();
        HashSet conflicts = new HashSet();
        DiffAnalysis baseToLeft = DiffUtil.mapDiff(base, left);
        DiffAnalysis baseToRight = DiffUtil.mapDiff(base, right);
        for (Object key : baseToLeft.added) {
            leftItem = left.get(key);
            rightItem = right.get(key);
            if (rightItem == null || leftItem.equals(rightItem)) {
                toAdd.add(key);
                continue;
            }
            conflicts.add(key);
        }
        for (Object key : baseToRight.added) {
            if (conflicts.contains(key)) continue;
            leftItem = left.get(key);
            rightItem = right.get(key);
            if (leftItem == null) {
                toAdd.add(key);
                continue;
            }
            if (rightItem.equals(leftItem)) continue;
            conflicts.add(key);
        }
        for (Object key : baseToLeft.deleted) {
            if (conflicts.contains(key)) continue;
            V rightItem2 = right.get(key);
            baseItem = base.get(key);
            if (rightItem2 == null || baseItem.equals(rightItem2)) {
                toDelete.add(key);
                continue;
            }
            conflicts.add(key);
        }
        for (Object key : baseToRight.deleted) {
            if (conflicts.contains(key)) continue;
            leftItem = left.get(key);
            baseItem = base.get(key);
            if (leftItem == null) continue;
            if (baseItem.equals(leftItem)) {
                toDelete.add(key);
                continue;
            }
            conflicts.add(key);
        }
        for (Object key : baseToLeft.modified) {
            V rightItem3;
            if (conflicts.contains(key)) continue;
            V baseItem2 = base.get(key);
            V leftItem2 = left.get(key);
            if (leftItem2.equals(rightItem3 = right.get(key)) || baseItem2.equals(rightItem3)) {
                toReplace.put(key, leftItem2);
                continue;
            }
            conflicts.add(key);
        }
        for (Object key : baseToRight.modified) {
            if (conflicts.contains(key)) continue;
            leftItem = left.get(key);
            rightItem = right.get(key);
            V baseItem3 = base.get(key);
            if (leftItem.equals(rightItem) || baseItem3.equals(leftItem)) {
                toReplace.put(key, rightItem);
                continue;
            }
            conflicts.add(key);
        }
        return new MergeAnalysis(toDelete, toAdd, toReplace, conflicts);
    }
}

