/*
 * Decompiled with CFR 0.152.
 */
package net.loomchild.maligna.filter.macro;

import java.util.ArrayList;
import java.util.List;
import net.loomchild.maligna.calculator.Calculator;
import net.loomchild.maligna.calculator.content.TranslationCalculator;
import net.loomchild.maligna.calculator.length.PoissonDistributionCalculator;
import net.loomchild.maligna.calculator.length.counter.SplitCounter;
import net.loomchild.maligna.calculator.meta.CompositeCalculator;
import net.loomchild.maligna.coretypes.Alignment;
import net.loomchild.maligna.filter.Filter;
import net.loomchild.maligna.filter.aligner.Aligner;
import net.loomchild.maligna.filter.aligner.align.hmm.adaptive.AdaptiveBandAlgorithm;
import net.loomchild.maligna.filter.aligner.align.hmm.fb.ForwardBackwardAlgorithmFactory;
import net.loomchild.maligna.filter.macro.Macro;
import net.loomchild.maligna.filter.meta.CompositeFilter;
import net.loomchild.maligna.filter.selector.FractionSelector;
import net.loomchild.maligna.filter.selector.OneToOneSelector;

public class PoissonTranslationMacro
implements Macro {
    public static final float SELECT_FRACTION = 0.9f;

    @Override
    public List<Alignment> apply(List<Alignment> alignmentList) {
        List<Alignment> bestAlignmentList = this.lengthAlign(alignmentList);
        return this.contentAlign(alignmentList, bestAlignmentList);
    }

    private List<Alignment> lengthAlign(List<Alignment> alignmentList) {
        ArrayList<Filter> filterList = new ArrayList<Filter>();
        SplitCounter counter = new SplitCounter();
        PoissonDistributionCalculator calculator = new PoissonDistributionCalculator(counter, alignmentList);
        ForwardBackwardAlgorithmFactory algorithmFactory = new ForwardBackwardAlgorithmFactory();
        AdaptiveBandAlgorithm algorithm = new AdaptiveBandAlgorithm(algorithmFactory, calculator);
        filterList.add(new Aligner(algorithm));
        filterList.add(new OneToOneSelector());
        filterList.add(new FractionSelector(0.9f));
        CompositeFilter filter = new CompositeFilter(filterList);
        return filter.apply(alignmentList);
    }

    private List<Alignment> contentAlign(List<Alignment> alignmentList, List<Alignment> bestAlignmentList) {
        ArrayList<Calculator> calculatorList = new ArrayList<Calculator>();
        SplitCounter counter = new SplitCounter();
        calculatorList.add(new PoissonDistributionCalculator(counter, alignmentList));
        calculatorList.add(new TranslationCalculator(bestAlignmentList));
        CompositeCalculator calculator = new CompositeCalculator(calculatorList);
        ForwardBackwardAlgorithmFactory algorithmFactory = new ForwardBackwardAlgorithmFactory();
        AdaptiveBandAlgorithm algorithm = new AdaptiveBandAlgorithm(algorithmFactory, calculator);
        Aligner filter = new Aligner(algorithm);
        return filter.apply(alignmentList);
    }
}

