/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.team2;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;
import org.apache.commons.io.FileUtils;

public class ProjectTeamSettings {
    private final File configFile;

    public ProjectTeamSettings(File configDir) {
        this.configFile = new File(configDir, "settings.properties");
    }

    public synchronized String get(String key) {
        try {
            Properties p = new Properties();
            if (this.configFile.exists()) {
                try (FileInputStream in = new FileInputStream(this.configFile);){
                    p.load(in);
                }
            }
            return p.getProperty(key);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public synchronized void set(String key, String newValue) {
        try {
            Properties p = new Properties();
            File f = this.configFile;
            File fNew = new File(this.configFile.getAbsolutePath() + ".new");
            if (f.exists()) {
                try (FileInputStream in = new FileInputStream(f);){
                    p.load(in);
                }
            } else {
                f.getParentFile().mkdirs();
            }
            if (newValue != null) {
                p.setProperty(key, newValue);
            } else {
                p.remove(key);
            }
            try (FileOutputStream out = new FileOutputStream(fNew);){
                p.store(out, null);
            }
            f.delete();
            FileUtils.moveFile((File)fNew, (File)f);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

