/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.team2.impl;

import gen.core.project.RepositoryDefinition;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.xml.namespace.QName;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.FetchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.LsRemoteCommand;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.SubmoduleUpdateCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.InvalidRemoteException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.TransportException;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.errors.NoRemoteRepositoryException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.CoreConfig;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.RemoteRefUpdate;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.omegat.core.team2.IRemoteRepository2;
import org.omegat.core.team2.ProjectTeamSettings;
import org.omegat.core.team2.impl.GITCredentialsProvider;
import org.omegat.util.Log;

public class GITRemoteRepository2
implements IRemoteRepository2 {
    private static final Logger LOGGER = Logger.getLogger(GITRemoteRepository2.class.getName());
    protected static final String LOCAL_BRANCH = "master";
    protected static final String REMOTE_BRANCH = "origin/master";
    protected static final String REMOTE = "origin";
    protected static final int TIMEOUT = 30;
    String repositoryURL;
    File localDirectory;
    protected Repository repository;
    ProjectTeamSettings projectTeamSettings;

    @Override
    public void init(RepositoryDefinition repo, File dir, ProjectTeamSettings teamSettings) throws Exception {
        Git git;
        this.repositoryURL = repo.getUrl();
        this.localDirectory = dir;
        this.projectTeamSettings = teamSettings;
        String predefinedUser = repo.getOtherAttributes().get(new QName("gitUsername"));
        String predefinedPass = repo.getOtherAttributes().get(new QName("gitPassword"));
        String predefinedFingerprint = repo.getOtherAttributes().get(new QName("gitFingerprint"));
        ((GITCredentialsProvider)CredentialsProvider.getDefault()).setPredefinedCredentials(this.repositoryURL, predefinedUser, predefinedPass, predefinedFingerprint);
        ((GITCredentialsProvider)CredentialsProvider.getDefault()).setTeamSettings(teamSettings);
        File gitDir = new File(this.localDirectory, ".git");
        if (gitDir.exists() && gitDir.isDirectory()) {
            this.repository = Git.open((File)this.localDirectory).getRepository();
            this.configRepo();
            git = new Git(this.repository);
            try {
                git.submoduleInit().call();
                ((SubmoduleUpdateCommand)git.submoduleUpdate().setTimeout(30)).call();
            }
            finally {
                git.close();
            }
        }
        Log.logInfoRB("GIT_START", "clone");
        CloneCommand c = Git.cloneRepository();
        c.setURI(this.repositoryURL);
        c.setDirectory(this.localDirectory);
        c.setTimeout(30);
        try {
            c.call();
        }
        catch (InvalidRemoteException e) {
            Throwable cause;
            if (this.localDirectory.exists()) {
                GITRemoteRepository2.deleteDirectory(this.localDirectory);
            }
            if ((cause = e.getCause()) != null && cause instanceof NoRemoteRepositoryException) {
                IRemoteRepository2.BadRepositoryException bre = new IRemoteRepository2.BadRepositoryException(((NoRemoteRepositoryException)cause).getLocalizedMessage());
                bre.initCause(e);
                throw bre;
            }
            throw e;
        }
        this.repository = Git.open((File)this.localDirectory).getRepository();
        try (Git git2 = new Git(this.repository);){
            git2.submoduleInit().call();
            ((SubmoduleUpdateCommand)git2.submoduleUpdate().setTimeout(30)).call();
        }
        this.configRepo();
        Log.logInfoRB("GIT_FINISH", "clone");
        git = new Git(this.repository);
        try {
            git.reset().setMode(ResetCommand.ResetType.HARD).call();
        }
        finally {
            git.close();
        }
    }

    private void configRepo() throws IOException {
        StoredConfig config = this.repository.getConfig();
        if ("\r\n".equals(System.lineSeparator())) {
            config.setBoolean("core", null, "autocrlf", true);
        } else {
            config.setEnum("core", null, "autocrlf", (Enum)CoreConfig.AutoCRLF.INPUT);
        }
        config.setBoolean("gc", null, "autoDetach", false);
        config.save();
    }

    @Override
    public String getFileVersion(String file) throws IOException {
        File f = new File(this.localDirectory, file);
        if (!f.exists()) {
            return null;
        }
        return this.getCurrentVersion();
    }

    protected String getCurrentVersion() throws IOException {
        try (RevWalk walk = new RevWalk(this.repository);){
            Ref localBranch = this.repository.findRef("HEAD");
            RevCommit headCommit = walk.lookupCommit((AnyObjectId)localBranch.getObjectId());
            String string = headCommit.getName();
            return string;
        }
    }

    @Override
    public void switchToVersion(String version) throws Exception {
        try (Git git = new Git(this.repository);){
            if (version == null) {
                version = REMOTE_BRANCH;
                ((FetchCommand)git.fetch().setRemote(REMOTE).setTimeout(30)).call();
            }
            Log.logDebug(LOGGER, "GIT switchToVersion {0} ", version);
            git.reset().setMode(ResetCommand.ResetType.HARD).call();
            git.checkout().setName(version).call();
            git.branchDelete().setForce(true).setBranchNames(new String[]{LOCAL_BRANCH}).call();
            git.checkout().setCreateBranch(true).setName(LOCAL_BRANCH).setStartPoint(version).call();
        }
        catch (TransportException e) {
            throw new IRemoteRepository2.NetworkException(e);
        }
    }

    @Override
    public void addForCommit(String path) throws Exception {
        Log.logInfoRB("GIT_START", "addForCommit");
        try (Git git = new Git(this.repository);){
            git.add().addFilepattern(path).call();
            Log.logInfoRB("GIT_FINISH", "addForCommit");
        }
        catch (Exception ex) {
            Log.logErrorRB("GIT_ERROR", "addForCommit", ex.getMessage());
            throw ex;
        }
    }

    @Override
    public void addForDeletion(String path) throws Exception {
        Log.logInfoRB("GIT_START", "addForDelete");
        try (Git git = new Git(this.repository);){
            git.rm().addFilepattern(path).call();
            Log.logInfoRB("GIT_FINISH", "addForDelete");
        }
        catch (Exception ex) {
            Log.logErrorRB("GIT_ERROR", "addForDelete", ex.getMessage());
            throw ex;
        }
    }

    @Override
    public File getLocalDirectory() {
        return this.localDirectory;
    }

    @Override
    public String[] getRecentlyDeletedFiles() throws Exception {
        ArrayList<String> deleted = new ArrayList<String>();
        ObjectId head = ((Ref)this.repository.getAllRefs().get("HEAD")).getObjectId();
        String settingKey = "lastDeleteCheckForName" + this.localDirectory.getName();
        String sinceRevisionString = this.projectTeamSettings.get(settingKey);
        ObjectId sinceRevision = sinceRevisionString == null ? head : ObjectId.fromString((String)sinceRevisionString);
        Git git = new Git(this.repository);
        AbstractTreeIterator startTreeIterator = this.getTreeIterator(git, sinceRevision);
        FileTreeIterator headTreeIterator = new FileTreeIterator(git.getRepository());
        List diffEntries = git.diff().setOldTree(startTreeIterator).setNewTree((AbstractTreeIterator)headTreeIterator).call();
        for (DiffEntry diffEntry : diffEntries) {
            if (!diffEntry.getChangeType().equals((Object)DiffEntry.ChangeType.DELETE)) continue;
            deleted.add(diffEntry.getOldPath().replace('/', File.separatorChar));
        }
        this.projectTeamSettings.set(settingKey, head.getName());
        String[] result = new String[deleted.size()];
        return deleted.toArray(result);
    }

    private AbstractTreeIterator getTreeIterator(Git git, ObjectId objectId) throws IOException {
        try (RevWalk walk = new RevWalk(git.getRepository());){
            CanonicalTreeParser canonicalTreeParser;
            block11: {
                RevCommit commit = walk.parseCommit((AnyObjectId)objectId);
                ObjectId treeId = commit.getTree().getId();
                ObjectReader reader = git.getRepository().newObjectReader();
                try {
                    canonicalTreeParser = new CanonicalTreeParser(null, reader, (AnyObjectId)treeId);
                    if (reader == null) break block11;
                }
                catch (Throwable throwable) {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                reader.close();
            }
            return canonicalTreeParser;
        }
    }

    @Override
    public String commit(String[] onVersions, String comment) throws Exception {
        String string;
        if (onVersions != null) {
            String currentVersion = this.getCurrentVersion();
            boolean hasVersion = false;
            for (String v : onVersions) {
                if (v == null) continue;
                hasVersion = true;
                break;
            }
            if (hasVersion) {
                boolean found = false;
                for (String v : onVersions) {
                    if (v == null || !v.equals(currentVersion)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    throw new RuntimeException("Version changed from " + Arrays.toString(onVersions) + " to " + currentVersion);
                }
            }
        }
        if (this.indexIsEmpty(DirCache.read((Repository)this.repository))) {
            Log.logInfoRB("GIT_NO_CHANGES", "upload");
            return null;
        }
        Log.logInfoRB("GIT_START", "upload");
        Git git = new Git(this.repository);
        try {
            String result;
            RevCommit commit = git.commit().setMessage(comment).call();
            Iterable results = ((PushCommand)git.push().setTimeout(30)).setRemote(REMOTE).add(LOCAL_BRANCH).call();
            List statuses = StreamSupport.stream(results.spliterator(), false).flatMap(r -> r.getRemoteUpdates().stream()).map(RemoteRefUpdate::getStatus).collect(Collectors.toList());
            if (statuses.isEmpty() || statuses.stream().anyMatch(s -> s != RemoteRefUpdate.Status.OK)) {
                Log.logWarningRB("GIT_CONFLICT", new Object[0]);
                result = null;
            } else {
                result = commit.getName();
            }
            Log.logDebug(LOGGER, "GIT committed into new version {0} ", result);
            Log.logInfoRB("GIT_FINISH", "upload");
            string = result;
        }
        catch (Throwable throwable) {
            try {
                try {
                    git.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception ex) {
                Log.logErrorRB("GIT_ERROR", "upload", ex.getMessage());
                if (ex instanceof TransportException) {
                    throw new IRemoteRepository2.NetworkException(ex);
                }
                throw ex;
            }
        }
        git.close();
        return string;
    }

    private boolean indexIsEmpty(DirCache dc) throws Exception {
        DirCacheIterator dci = new DirCacheIterator(dc);
        AbstractTreeIterator old = GITRemoteRepository2.prepareTreeParser(this.repository, this.repository.resolve("HEAD"));
        try (Git git = new Git(this.repository);){
            List diffs = git.diff().setOldTree(old).setNewTree((AbstractTreeIterator)dci).call();
            boolean bl = diffs.isEmpty();
            return bl;
        }
    }

    private static AbstractTreeIterator prepareTreeParser(Repository repository, ObjectId objId) throws Exception {
        try (RevWalk walk = new RevWalk(repository);){
            RevCommit commit = walk.parseCommit((AnyObjectId)objId);
            RevTree tree = walk.parseTree((AnyObjectId)commit.getTree().getId());
            CanonicalTreeParser treeParser = new CanonicalTreeParser();
            ObjectReader reader = repository.newObjectReader();
            treeParser.reset(reader, (AnyObjectId)tree.getId());
            CanonicalTreeParser canonicalTreeParser = treeParser;
            return canonicalTreeParser;
        }
    }

    public static boolean deleteDirectory(File path) {
        if (path.exists()) {
            File[] files = path.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    GITRemoteRepository2.deleteDirectory(files[i]);
                    continue;
                }
                files[i].delete();
            }
        }
        return path.delete();
    }

    public static boolean isGitRepository(String url) {
        try {
            Collection result = ((LsRemoteCommand)new LsRemoteCommand(null).setRemote(url).setTimeout(30)).call();
            return !result.isEmpty();
        }
        catch (TransportException ex) {
            String message = ex.getMessage();
            return message.endsWith("not authorized") || message.endsWith("Auth fail") || message.contains("Too many authentication failures") || message.contains("Authentication is required");
        }
        catch (GitAPIException ex) {
            return false;
        }
        catch (JGitInternalException ex) {
            return false;
        }
    }

    static {
        CredentialsProvider.setDefault((CredentialsProvider)new GITCredentialsProvider());
    }
}

