/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.glossary;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import javax.swing.text.AttributeSet;
import javax.swing.text.Caret;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.omegat.core.Core;
import org.omegat.core.data.ProjectProperties;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.StringEntry;
import org.omegat.gui.common.EntryInfoThreadPane;
import org.omegat.gui.dialogs.CreateGlossaryEntry;
import org.omegat.gui.editor.EditorUtils;
import org.omegat.gui.glossary.FindGlossaryThread;
import org.omegat.gui.glossary.GlossaryEntry;
import org.omegat.gui.glossary.GlossaryReaderTSV;
import org.omegat.gui.glossary.GlossaryRenderers;
import org.omegat.gui.glossary.IGlossaries;
import org.omegat.gui.glossary.IGlossaryRenderer;
import org.omegat.gui.glossary.TransTipsMarker;
import org.omegat.gui.glossary.TransTipsPopup;
import org.omegat.gui.main.DockableScrollPane;
import org.omegat.gui.main.IMainWindow;
import org.omegat.gui.shortcuts.PropertiesShortcuts;
import org.omegat.util.Java8Compat;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.StringUtil;
import org.omegat.util.gui.DragTargetOverlay;
import org.omegat.util.gui.IPaneMenu;
import org.omegat.util.gui.JTextPaneLinkifier;
import org.omegat.util.gui.StaticUIUtils;
import org.omegat.util.gui.TooltipAttribute;
import org.omegat.util.gui.UIThreadsUtil;

public class GlossaryTextArea
extends EntryInfoThreadPane<List<GlossaryEntry>>
implements IGlossaries,
IPaneMenu {
    private static final String EXPLANATION = OStrings.getString("GUI_GLOSSARYWINDOW_explanation");
    protected StringEntry processedEntry;
    protected static List<GlossaryEntry> nowEntries;
    private CreateGlossaryEntry createGlossaryEntryDialog;
    private final DockableScrollPane scrollPane;
    protected final transient MouseListener mouseListener = new MouseAdapter(){

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.doPopup(e.getPoint());
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.doPopup(e.getPoint());
            }
        }

        private void doPopup(Point p) {
            JPopupMenu popup = new JPopupMenu();
            GlossaryTextArea.this.populateContextMenu(popup);
            popup.show(GlossaryTextArea.this, p.x, p.y);
        }
    };

    public GlossaryTextArea(IMainWindow mw) {
        super(true);
        String title = OStrings.getString("GUI_MATCHWINDOW_SUBWINDOWTITLE_Glossary");
        this.scrollPane = new DockableScrollPane("GLOSSARY", title, this, true);
        mw.addDockable(this.scrollPane);
        this.setEditable(false);
        StaticUIUtils.makeCaretAlwaysVisible(this);
        this.setText(EXPLANATION);
        this.setMinimumSize(new Dimension(100, 50));
        this.addMouseListener(this.mouseListener);
        Core.getEditor().registerPopupMenuConstructors(300, new TransTipsPopup());
        if (!GraphicsEnvironment.isHeadless()) {
            DragTargetOverlay.apply(this, new DragTargetOverlay.FileDropInfo(false){

                @Override
                public boolean canAcceptDrop() {
                    return Core.getProject().isProjectLoaded();
                }

                @Override
                public String getOverlayMessage() {
                    return OStrings.getString("DND_ADD_GLOSSARY_FILE");
                }

                @Override
                public String getImportDestination() {
                    return Core.getProject().getProjectProperties().getGlossaryRoot();
                }

                @Override
                public boolean acceptFile(File pathname) {
                    String name = pathname.getName().toLowerCase(Locale.ENGLISH);
                    return name.endsWith(".csv") || name.endsWith(".tbx") || name.endsWith(".tab") || name.endsWith(".txt") || name.endsWith(".tsv") || name.endsWith(".utf8");
                }

                @Override
                public Component getComponentToOverlay() {
                    return GlossaryTextArea.this.scrollPane;
                }
            });
        }
        ToolTipManager.sharedInstance().registerComponent(this);
        JTextPaneLinkifier.linkify(this);
    }

    @Override
    protected void onProjectOpen() {
        this.clear();
        Core.getGlossaryManager().start();
    }

    @Override
    protected void onProjectClose() {
        this.clear();
        this.setText(EXPLANATION);
        Core.getGlossaryManager().stop();
    }

    @Override
    protected void startSearchThread(SourceTextEntry newEntry) {
        new FindGlossaryThread(this, newEntry, Core.getGlossaryManager()).start();
    }

    public void refresh() {
        SourceTextEntry ste = Core.getEditor().getCurrentEntry();
        if (ste != null) {
            this.startSearchThread(ste);
        }
    }

    @Override
    public void onEntryActivated(SourceTextEntry newEntry) {
        this.scrollPane.stopNotifying();
        super.onEntryActivated(newEntry);
    }

    @Override
    protected void setFoundResult(SourceTextEntry en, List<GlossaryEntry> entries) {
        UIThreadsUtil.mustBeSwingThread();
        this.clear();
        if (entries == null) {
            return;
        }
        if (!entries.isEmpty() && Preferences.isPreference("notify_glossary_hits")) {
            this.scrollPane.notify(true);
        }
        nowEntries = entries;
        if (Core.getEditor().getSettings().isMarkGlossaryMatches()) {
            Core.getEditor().remarkOneMarker(TransTipsMarker.class.getName());
        }
        IGlossaryRenderer entryRenderer = GlossaryRenderers.getPreferredGlossaryRenderer();
        for (GlossaryEntry entry : entries) {
            entryRenderer.render(entry, this.getStyledDocument());
        }
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        StyledDocument doc = this.getStyledDocument();
        Element elem = doc.getCharacterElement(Java8Compat.viewToModel(this, event.getPoint()));
        AttributeSet as = elem.getAttributes();
        Object attr = as.getAttribute("tooltip_payload");
        if (attr instanceof TooltipAttribute) {
            return ((TooltipAttribute)attr).getPayload();
        }
        return super.getToolTipText(event);
    }

    @Override
    public void clear() {
        super.clear();
        nowEntries = Collections.emptyList();
    }

    @Override
    public List<GlossaryEntry> getDisplayedEntries() {
        return nowEntries;
    }

    private void populateContextMenu(JPopupMenu popup) {
        boolean projectLoaded = Core.getProject().isProjectLoaded();
        final String selection = this.getSelectedText();
        JMenuItem item = popup.add(OStrings.getString("GUI_GLOSSARYWINDOW_insertselection"));
        item.setEnabled(projectLoaded && !StringUtil.isEmpty(selection));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Core.getEditor().insertText(selection);
            }
        });
        item = popup.add(OStrings.getString("GUI_GLOSSARYWINDOW_addentry"));
        item.setEnabled(projectLoaded);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GlossaryTextArea.this.showCreateGlossaryEntryDialog(Core.getMainWindow().getApplicationFrame());
            }
        });
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        KeyStroke s = KeyStroke.getKeyStrokeForEvent(e);
        if (s.equals(PropertiesShortcuts.getEditorShortcuts().getKeyStroke("editorContextMenu"))) {
            JPopupMenu popup = new JPopupMenu();
            this.populateContextMenu(popup);
            Caret caret = this.getCaret();
            Point p = caret == null ? this.getMousePosition() : caret.getMagicCaretPosition();
            popup.show(this, (int)p.getX(), (int)p.getY());
            e.consume();
        }
        super.processKeyEvent(e);
    }

    @Override
    public void showCreateGlossaryEntryDialog(Frame parent) {
        CreateGlossaryEntry d = this.createGlossaryEntryDialog;
        if (d != null) {
            d.requestFocus();
            return;
        }
        ProjectProperties props = Core.getProject().getProjectProperties();
        final File out = new File(props.getWriteableGlossary());
        final CreateGlossaryEntry dialog = new CreateGlossaryEntry(parent);
        String txt = dialog.getGlossaryFileText().getText();
        txt = MessageFormat.format(txt, out.getAbsolutePath());
        dialog.getGlossaryFileText().setText(txt);
        dialog.getSourceText().requestFocus();
        dialog.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowLostFocus(WindowEvent e) {
            }

            @Override
            public void windowGainedFocus(WindowEvent e) {
                String sel;
                Window w = e.getOppositeWindow();
                if (w != null && !StringUtil.isEmpty(sel = this.getSelectedText(w.getMostRecentFocusOwner()))) {
                    if (StringUtil.isEmpty(dialog.getSourceText().getText())) {
                        this.setText(dialog.getSourceText(), sel);
                    } else if (StringUtil.isEmpty(dialog.getTargetText().getText())) {
                        this.setText(dialog.getTargetText(), sel);
                    } else if (StringUtil.isEmpty(dialog.getCommentText().getText())) {
                        this.setText(dialog.getCommentText(), sel);
                    }
                }
            }

            private String getSelectedText(Component comp) {
                String result = null;
                if (comp instanceof JTextComponent && !StringUtil.isEmpty(result = ((JTextComponent)comp).getSelectedText())) {
                    result = EditorUtils.removeDirectionChars(result);
                }
                return result;
            }

            private void setText(JTextComponent comp, String text) {
                comp.setText(text);
                comp.requestFocus();
                comp.selectAll();
            }
        });
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                GlossaryTextArea.this.createGlossaryEntryDialog = null;
                if (dialog.getReturnStatus() == 1) {
                    String src = StringUtil.normalizeUnicode(dialog.getSourceText().getText()).trim();
                    String loc = StringUtil.normalizeUnicode(dialog.getTargetText().getText()).trim();
                    String com = StringUtil.normalizeUnicode(dialog.getCommentText().getText()).trim();
                    if (!StringUtil.isEmpty(src) && !StringUtil.isEmpty(loc)) {
                        try {
                            GlossaryReaderTSV.append(out, new GlossaryEntry(src, loc, com, true, out.getPath()));
                        }
                        catch (Exception ex) {
                            Log.log(ex);
                        }
                    }
                }
            }
        });
        StaticUIUtils.persistGeometry(dialog, "create_glossary_dialog");
        dialog.setVisible(true);
        this.createGlossaryEntryDialog = dialog;
    }

    @Override
    public void populatePaneMenu(JPopupMenu menu) {
        this.populateContextMenu(menu);
        menu.addSeparator();
        JMenuItem openFile = new JMenuItem(OStrings.getString("GUI_GLOSSARYWINDOW_SETTINGS_OPEN_FILE"));
        openFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Core.getMainWindow().getMainMenu().invokeAction("projectAccessWriteableGlossaryMenuItem", e.getModifiers());
            }
        });
        openFile.setEnabled(false);
        if (Core.getProject().isProjectLoaded()) {
            String glossaryPath = Core.getProject().getProjectProperties().getWriteableGlossary();
            openFile.setEnabled(!StringUtil.isEmpty(glossaryPath) && new File(glossaryPath).isFile());
        }
        menu.add(openFile);
        menu.addSeparator();
        final JCheckBoxMenuItem notify = new JCheckBoxMenuItem(OStrings.getString("GUI_GLOSSARYWINDOW_SETTINGS_NOTIFICATIONS"));
        notify.setSelected(Preferences.isPreference("notify_glossary_hits"));
        notify.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Preferences.setPreference("notify_glossary_hits", notify.isSelected());
            }
        });
        menu.add(notify);
    }
}

