/*
 * Decompiled with CFR 0.152.
 */
package net.loomchild.maligna.filter.aligner.align.onetoone;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.loomchild.maligna.coretypes.Alignment;
import net.loomchild.maligna.filter.aligner.AlignmentImpossibleException;
import net.loomchild.maligna.filter.aligner.align.AlignAlgorithm;

public class OneToOneAlgorithm
implements AlignAlgorithm {
    public static final boolean DEFAULT_STRICT = false;
    private boolean strict;

    public OneToOneAlgorithm(boolean strict) {
        this.strict = strict;
    }

    public OneToOneAlgorithm() {
        this(false);
    }

    @Override
    public List<Alignment> align(List<String> sourceSegmentList, List<String> targetSegmentList) {
        if (this.strict && sourceSegmentList.size() != targetSegmentList.size()) {
            throw new AlignmentImpossibleException("Cannot align 1 to 1 - segment amounts are not equal");
        }
        if (sourceSegmentList.size() == 0 && targetSegmentList.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<Alignment> alignmentList = new ArrayList<Alignment>(sourceSegmentList.size());
        Iterator<String> sourceIterator = sourceSegmentList.iterator();
        Iterator<String> targetIterator = targetSegmentList.iterator();
        while (sourceIterator.hasNext() || targetIterator.hasNext()) {
            Alignment alignment = new Alignment(this.getSegmentList(sourceIterator), this.getSegmentList(targetIterator), 0.0f);
            alignmentList.add(alignment);
        }
        return alignmentList;
    }

    private List<String> getSegmentList(Iterator<String> iterator) {
        if (iterator.hasNext()) {
            return Collections.singletonList(iterator.next());
        }
        return Collections.emptyList();
    }
}

