/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util;

import java.awt.GraphicsEnvironment;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;
import org.omegat.util.HttpConnectionUtils;
import org.omegat.util.Log;
import org.omegat.util.Platform;
import org.omegat.util.RuntimePreferences;
import org.omegat.util.StringUtil;

public final class StaticUtils {
    private static final String WINDOWS_CONFIG_DIR = "\\OmegaT\\";
    private static final String UNIX_CONFIG_DIR = "/.omegat/";
    private static final String OSX_CONFIG_DIR = "/Library/Preferences/OmegaT/";
    private static final String SCRIPT_DIR = "script";
    public static final char TAG_REPLACEMENT_CHAR = '\b';
    public static final String TAG_REPLACEMENT = "\b";
    private static String configDir = null;
    private static String scriptDir = null;
    private static String installDir = null;

    private StaticUtils() {
    }

    public static boolean isKey(KeyEvent e, int code, int modifiers) {
        return e.getKeyCode() == code && e.getModifiersEx() == modifiers;
    }

    public static String[] getFontNames() {
        GraphicsEnvironment graphics = GraphicsEnvironment.getLocalGraphicsEnvironment();
        return graphics.getAvailableFontFamilyNames();
    }

    public static String installDir() {
        if (installDir == null) {
            File file = null;
            try {
                File uriFile;
                URI sourceUri = StaticUtils.class.getProtectionDomain().getCodeSource().getLocation().toURI();
                if (sourceUri.getScheme().equals("file") && (uriFile = Paths.get(sourceUri).toFile()).getName().endsWith(".jar")) {
                    file = uriFile.getParentFile();
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            if (file == null) {
                file = Paths.get(".", new String[0]).toFile();
            }
            installDir = file.getAbsolutePath();
        }
        return installDir;
    }

    public static String getConfigDir() {
        String home;
        if (configDir != null) {
            return configDir;
        }
        String cd = RuntimePreferences.getConfigDir();
        if (cd != null) {
            configDir = new File(cd).getAbsolutePath() + File.separator;
            return configDir;
        }
        Platform.OsType os = Platform.getOsType();
        try {
            home = System.getProperty("user.home");
        }
        catch (SecurityException e) {
            configDir = new File(".").getAbsolutePath() + File.separator;
            Log.logErrorRB("SU_USERHOME_PROP_ACCESS_ERROR", new Object[0]);
            Log.log(e.toString());
            return configDir;
        }
        if (os == null || StringUtil.isEmpty(home)) {
            configDir = new File(".").getAbsolutePath() + File.separator;
            return configDir;
        }
        if (os == Platform.OsType.WIN32 || os == Platform.OsType.WIN64) {
            String appData = null;
            File appDataFile = new File(home, "AppData\\Roaming");
            if (appDataFile.exists()) {
                appData = appDataFile.getAbsolutePath();
            } else {
                appDataFile = new File(home, "Application Data");
                if (appDataFile.exists()) {
                    appData = appDataFile.getAbsolutePath();
                }
            }
            configDir = !StringUtil.isEmpty(appData) ? appData + WINDOWS_CONFIG_DIR : home + WINDOWS_CONFIG_DIR;
        } else {
            configDir = os == Platform.OsType.LINUX32 || os == Platform.OsType.LINUX64 || os == Platform.OsType.OTHER ? home + UNIX_CONFIG_DIR : (Platform.isMacOSX() ? home + OSX_CONFIG_DIR : home + File.separator);
        }
        if (!configDir.isEmpty()) {
            try {
                boolean created;
                File dir = new File(configDir);
                if (!dir.exists() && !(created = dir.mkdirs())) {
                    Log.logErrorRB("SU_CONFIG_DIR_CREATE_ERROR", new Object[0]);
                    configDir = new File(".").getAbsolutePath() + File.separator;
                }
            }
            catch (SecurityException e) {
                configDir = new File(".").getAbsolutePath() + File.separator;
                Log.logErrorRB("SU_CONFIG_DIR_CREATE_ERROR", new Object[0]);
                Log.log(e.toString());
            }
        }
        return configDir;
    }

    public static String getScriptDir() {
        if (scriptDir != null) {
            return scriptDir;
        }
        scriptDir = StaticUtils.getConfigDir() + SCRIPT_DIR + File.separator;
        try {
            boolean created;
            File dir = new File(scriptDir);
            if (!dir.exists() && !(created = dir.mkdirs())) {
                Log.logErrorRB("SU_SCRIPT_DIR_CREATE_ERROR", new Object[0]);
                scriptDir = StaticUtils.getConfigDir();
            }
        }
        catch (SecurityException e) {
            scriptDir = StaticUtils.getConfigDir();
            Log.logErrorRB("SU_SCRIPT_DIR_CREATE_ERROR", new Object[0]);
            Log.log(e.toString());
        }
        return scriptDir;
    }

    public static String uuencode(byte[] buf) {
        if (buf.length <= 0) {
            return "";
        }
        StringBuilder res = new StringBuilder();
        res.append(buf[0]);
        for (int i = 1; i < buf.length; ++i) {
            res.append('#');
            res.append(buf[i]);
        }
        return res.toString();
    }

    public static byte[] uudecode(String buf) {
        String[] bytes = buf.split("#");
        byte[] res = new byte[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            try {
                res[i] = Byte.parseByte(bytes[i]);
                continue;
            }
            catch (NumberFormatException e) {
                res[i] = 0;
            }
        }
        return res;
    }

    public static String makeFilenameRelative(String filename, String path) {
        if (filename.toLowerCase().startsWith(path.toLowerCase())) {
            return filename.substring(path.length());
        }
        return filename;
    }

    public static String globToRegex(String text, boolean spaceMatchesNbsp) {
        String quoted = Pattern.quote(text);
        StringBuilder sb = new StringBuilder(quoted);
        assert (quoted.startsWith("\\Q"));
        assert (quoted.endsWith("\\E"));
        if (spaceMatchesNbsp) {
            StaticUtils.replaceGlobs(sb, "*", "[^\\s\u00a0]*");
            StaticUtils.replaceGlobs(sb, "?", "[^\\s\u00a0]");
            StaticUtils.replaceGlobs(sb, " ", "(?: |\u00a0)");
        } else {
            StaticUtils.replaceGlobs(sb, "*", "\\S*");
            StaticUtils.replaceGlobs(sb, "?", "\\S");
        }
        return sb.toString();
    }

    private static void replaceGlobs(StringBuilder haystack, String needle, String replacement) {
        replacement = "\\E" + replacement + "\\Q";
        int current = 0;
        int globIndex = 0;
        while ((globIndex = haystack.indexOf(needle, current)) != -1) {
            haystack.replace(globIndex, globIndex + 1, replacement);
            current = globIndex + replacement.length();
        }
    }

    @Deprecated
    public static String downloadFileToString(URL url, int timeout) throws IOException {
        return HttpConnectionUtils.getURL(url, timeout);
    }

    public static List<String> extractFromZip(InputStream in, File destination, Predicate<String> filenameFilter) throws IOException {
        ArrayList<String> extracted = new ArrayList<String>();
        try (PushbackInputStream pis = new PushbackInputStream(in, 2);){
            byte[] sig = new byte[2];
            pis.read(sig);
            if (sig[0] != 80 || sig[1] != 75) {
                throw new IllegalArgumentException("Input stream was not a zip file");
            }
            pis.unread(sig);
            try (ZipInputStream zis = new ZipInputStream(pis);){
                ZipEntry entry;
                while ((entry = zis.getNextEntry()) != null) {
                    if (!filenameFilter.test(entry.getName())) continue;
                    File f = new File(destination, entry.getName());
                    FileUtils.copyToFile((InputStream)zis, (File)f);
                    extracted.add(entry.getName());
                }
            }
        }
        return extracted;
    }

    public static String[] parseCLICommand(String cmd) {
        int cp;
        if ((cmd = cmd.trim()).isEmpty()) {
            return new String[]{""};
        }
        StringBuilder arg = new StringBuilder();
        ArrayList<String> result = new ArrayList<String>();
        boolean noQuote = false;
        int currentQuote = 0;
        for (int i = 0; i < cmd.length(); i += Character.charCount(cp)) {
            cp = cmd.codePointAt(i);
            if (cp == currentQuote) {
                currentQuote = 0;
                continue;
            }
            if (cp == 34 && currentQuote == 0) {
                currentQuote = 34;
                continue;
            }
            if (cp == 39 && currentQuote == 0) {
                currentQuote = 39;
                continue;
            }
            if (cp == 92 && i + 1 < cmd.length()) {
                int ncp = cmd.codePointAt(cmd.offsetByCodePoints(i, 1));
                if (currentQuote == 0 && Character.isWhitespace(ncp) || currentQuote == 34 && ncp == 34) {
                    arg.appendCodePoint(ncp);
                    i += Character.charCount(ncp);
                    continue;
                }
                arg.appendCodePoint(cp);
                continue;
            }
            if (Character.isWhitespace(cp) && currentQuote == 0) {
                if (arg.length() <= 0) continue;
                result.add(arg.toString());
                arg = new StringBuilder();
                continue;
            }
            arg.appendCodePoint(cp);
        }
        if (arg.length() > 0) {
            result.add(arg.toString());
        }
        return result.toArray(new String[result.size()]);
    }

    public static boolean isProjectDir(File f) {
        if (f == null || f.getName().isEmpty()) {
            return false;
        }
        File projFile = new File(f.getAbsolutePath(), "omegat.project");
        return projFile.isFile();
    }

    public static <T> boolean arraysMatchAt(T[] needles, T[] haystack, int offset) {
        if (offset < 0 || offset >= haystack.length) {
            throw new ArrayIndexOutOfBoundsException(offset);
        }
        if (haystack.length - offset < needles.length) {
            return false;
        }
        for (int i = 0; i < needles.length; ++i) {
            if (Objects.equals(haystack[i + offset], needles[i])) continue;
            return false;
        }
        return true;
    }
}

