/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.omegat.util.HttpConnectionUtils;

public final class WikiGet {
    private WikiGet() {
    }

    public static String joinString(String separator, String[] items) {
        if (items.length < 1) {
            return "";
        }
        StringBuilder joined = new StringBuilder();
        for (int i = 0; i < items.length; ++i) {
            joined.append(items[i]);
            if (i == items.length - 1) continue;
            joined.append(separator);
        }
        return joined.toString();
    }

    public static void doWikiGet(String remoteUrl, String projectdir) throws IOException {
        String[] splitted;
        String joined = null;
        String name = null;
        if (remoteUrl.indexOf("index.php?title=") > 0) {
            String s;
            splitted = remoteUrl.split("index.php\\?title=");
            name = s = splitted[splitted.length - 1];
            splitted[splitted.length - 1] = s = s.replaceAll(" ", "_");
            joined = WikiGet.joinString("index.php?title=", splitted);
            joined = joined + "&action=raw";
        } else {
            String s;
            splitted = remoteUrl.split("/");
            name = s = splitted[splitted.length - 1];
            splitted[splitted.length - 1] = s = s.replaceAll(" ", "_");
            joined = WikiGet.joinString("/", splitted);
            joined = joined + "?action=raw";
        }
        String page = HttpConnectionUtils.getURL(new URL(joined));
        WikiGet.saveUTF8(projectdir, name + ".UTF8", page);
    }

    public static void printUTF8(String output) {
        try (BufferedWriter out = WikiGet.utf8WriterBuilder(System.out);){
            out.write(output);
            out.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static BufferedWriter utf8WriterBuilder(OutputStream out) throws Exception {
        return new BufferedWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8.name()));
    }

    public static void saveUTF8(String dir, String filename, String output) {
        filename = filename.replaceAll("[\\\\/:\\*\\?\\\"\\|\\<\\>]", "_");
        File path = new File(dir, filename);
        try (BufferedWriter out = WikiGet.utf8WriterBuilder(new FileOutputStream(path));){
            out.write(output);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Deprecated
    public static String getURL(String target) throws IOException {
        return HttpConnectionUtils.getURL(new URL(target));
    }

    @Deprecated
    public static byte[] getURLasByteArray(String target) throws IOException {
        return HttpConnectionUtils.getURLasByteArray(target);
    }

    @Deprecated
    public static String post(String address, Map<String, String> params) throws IOException {
        return HttpConnectionUtils.post(address, params, null);
    }

    @Deprecated
    public static String get(String address, Map<String, String> params, Map<String, String> additionalHeaders) throws IOException {
        return HttpConnectionUtils.get(address, params, additionalHeaders);
    }

    @Deprecated
    public static String get(String address, Map<String, String> params, Map<String, String> additionalHeaders, String defaultOutputCharset) throws IOException {
        return HttpConnectionUtils.get(address, params, additionalHeaders, defaultOutputCharset);
    }

    @Deprecated
    public static String post(String address, Map<String, String> params, Map<String, String> additionalHeaders) throws IOException {
        return HttpConnectionUtils.post(address, params, additionalHeaders);
    }

    @Deprecated
    public static String postJSON(String address, String json, Map<String, String> additionalHeaders) throws IOException {
        return HttpConnectionUtils.postJSON(address, json, additionalHeaders);
    }

    @Deprecated
    public static class ResponseError
    extends HttpConnectionUtils.ResponseError {
        public ResponseError(HttpURLConnection conn) throws IOException {
            super(conn);
        }
    }
}

