/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.machinetranslators;

import java.awt.Window;
import java.util.Map;
import java.util.TreeMap;
import org.omegat.core.machinetranslators.BaseTranslate;
import org.omegat.gui.exttrans.MTConfigDialog;
import org.omegat.util.HttpConnectionUtils;
import org.omegat.util.JsonParser;
import org.omegat.util.Language;
import org.omegat.util.OStrings;

public abstract class AbstractMyMemoryTranslate
extends BaseTranslate {
    private static final String MYMEMORY_API_EMAIL = "mymemory.api.email";
    private static final String MYMEMORY_API_KEY = "mymemory.api.key";
    private static final String GT_URL = "https://mymemory.translated.net/api/get";

    @Override
    protected abstract String getPreferenceName();

    @Override
    public abstract String getName();

    protected String mymemoryCode(Language language) {
        return language.getLocaleLCID();
    }

    @Override
    protected abstract String translate(Language var1, Language var2, String var3) throws Exception;

    protected Map<String, Object> getMyMemoryResponse(Language sLang, Language tLang, String text) throws Exception {
        String targetLang = tLang.getLocaleLCID();
        String sourceLang = sLang.getLocaleLCID();
        String apiKey = this.getCredential(MYMEMORY_API_KEY);
        String email = this.getCredential(MYMEMORY_API_EMAIL);
        TreeMap<String, String> params = new TreeMap<String, String>();
        params.put("q", text);
        params.put("langpair", sourceLang + "|" + targetLang);
        params.put("of", "json");
        params.put("mt", this.includeMT() ? "1" : "0");
        if (!apiKey.isEmpty()) {
            params.put("key", apiKey);
        }
        if (!email.isEmpty()) {
            params.put("de", email);
        }
        TreeMap<String, String> headers = new TreeMap<String, String>();
        String myMemoryJson = "";
        myMemoryJson = HttpConnectionUtils.get(GT_URL, params, headers);
        return (Map)JsonParser.parse(myMemoryJson);
    }

    @Override
    public boolean isConfigurable() {
        return true;
    }

    @Override
    public void showConfigurationUI(Window parent) {
        MTConfigDialog dialog = new MTConfigDialog(parent, this.getName()){

            @Override
            protected void onConfirm() {
                String email = this.panel.valueField1.getText().trim();
                boolean temporary = this.panel.temporaryCheckBox.isSelected();
                AbstractMyMemoryTranslate.this.setCredential(AbstractMyMemoryTranslate.MYMEMORY_API_EMAIL, email, temporary);
            }
        };
        dialog.panel.valueLabel1.setText(OStrings.getString("MT_ENGINE_MYMEMORY_EMAIL_LABEL"));
        dialog.panel.valueField1.setText(this.getCredential(MYMEMORY_API_EMAIL));
        dialog.panel.valueLabel2.setText(OStrings.getString("MT_ENGINE_MYMEMORY_API_KEY_LABEL"));
        dialog.panel.valueField2.setText(this.getCredential(MYMEMORY_API_KEY));
        dialog.panel.temporaryCheckBox.setSelected(this.isCredentialStoredTemporarily(MYMEMORY_API_EMAIL));
        dialog.show();
    }

    protected abstract boolean includeMT();
}

