/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.properties;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.omegat.core.Core;
import org.omegat.gui.properties.ISegmentPropertiesView;
import org.omegat.gui.properties.SegmentPropertiesArea;
import org.omegat.gui.properties.SegmentPropertiesListCell;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.gui.ReasonablySizedPanel;
import org.omegat.util.gui.UIThreadsUtil;

public class SegmentPropertiesListView
implements ISegmentPropertiesView {
    private SegmentPropertiesArea parent;
    private JPanel panel;

    @Override
    public void install(SegmentPropertiesArea parent) {
        this.parent = parent;
        this.panel = new ReasonablySizedPanel();
        this.panel.setLayout(new BoxLayout(this.panel, 1));
        this.panel.setFont(Core.getMainWindow().getApplicationFont());
        this.panel.setOpaque(true);
        parent.scrollPane.setViewportView(this.panel);
    }

    @Override
    public void update() {
        UIThreadsUtil.mustBeSwingThread();
        this.panel.removeAll();
        for (int i = 0; i < this.parent.properties.size(); i += 2) {
            String key;
            final SegmentPropertiesListCell cell = new SegmentPropertiesListCell();
            cell.key = key = this.parent.properties.get(i);
            cell.label.setText(this.getDisplayKey(key));
            cell.value.setText(this.parent.properties.get(i + 1));
            cell.value.setFont(this.panel.getFont());
            cell.settingsButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SegmentPropertiesListView.this.parent.showContextMenu(SwingUtilities.convertPoint(cell, cell.settingsButton.getLocation(), ((SegmentPropertiesListView)SegmentPropertiesListView.this).parent.scrollPane));
                }
            });
            this.panel.add(cell);
        }
        this.panel.validate();
        this.panel.repaint();
    }

    private String getDisplayKey(String key) {
        if (Preferences.isPreference("segment_properties_show_raw_keys")) {
            return key;
        }
        try {
            return OStrings.getString("SEGPROP_KEY_" + key.toUpperCase(Locale.ENGLISH));
        }
        catch (MissingResourceException ex) {
            return key;
        }
    }

    @Override
    public JComponent getViewComponent() {
        return this.panel;
    }

    @Override
    public void notifyUser(List<Integer> notify) {
        UIThreadsUtil.mustBeSwingThread();
        for (int i : notify) {
            try {
                ((SegmentPropertiesListCell)this.panel.getComponent((int)(i / 2))).value.flash();
            }
            catch (IndexOutOfBoundsException ex) {
                break;
            }
        }
    }

    @Override
    public String getKeyAtPoint(Point p) {
        Component comp = this.panel.getComponentAt(p);
        if (comp instanceof SegmentPropertiesListCell) {
            return ((SegmentPropertiesListCell)comp).key;
        }
        return null;
    }
}

