/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util;

import java.util.ArrayDeque;
import java.util.Map;
import java.util.TreeMap;
import org.omegat.filters3.Tag;
import org.omegat.util.StringUtil;

public class InlineTagHandler {
    Map<String, Integer> pairTags = new TreeMap<String, Integer>();
    Map<String, String> pairTagsExternalMatch = new TreeMap<String, String>();
    Map<String, ArrayDeque<Integer>> pairedOtherTags = new TreeMap<String, ArrayDeque<Integer>>();
    Map<String, Integer> shortcutLetters = new TreeMap<String, Integer>();
    String currentI;
    String currentX;
    String currentPos;
    int tagIndex;
    int otherTagShortcutLetter;

    public void reset() {
        this.pairTags.clear();
        this.pairTagsExternalMatch.clear();
        this.pairedOtherTags.clear();
        this.currentI = null;
        this.currentX = null;
        this.currentPos = null;
        this.tagIndex = 0;
    }

    public void startBPT(String i, String x) {
        if (i == null) {
            throw new RuntimeException("Wrong index in inline tag");
        }
        this.currentI = i;
        this.currentX = x;
        this.pairTags.put(this.currentI, this.tagIndex++);
        this.pairTagsExternalMatch.put(this.currentI, x);
    }

    public void startIT(String x) {
        this.currentX = x;
    }

    public void startPH(String x) {
        this.currentX = x;
    }

    public void startBPT(String ... attributeValues) {
        this.currentI = this.nvl(attributeValues);
        this.currentX = null;
        this.pairTags.put(this.currentI, this.tagIndex++);
    }

    public void setTagShortcutLetter(int letter) {
        if (letter != 0) {
            this.shortcutLetters.put(this.currentI, letter);
        }
    }

    public int getTagShortcutLetter() {
        Integer c = this.shortcutLetters.get(this.currentI);
        return c != null ? c : 0;
    }

    public void setOtherTagShortcutLetter(int letter) {
        this.otherTagShortcutLetter = letter;
    }

    public int getOtherTagShortcutLetter() {
        return this.otherTagShortcutLetter;
    }

    public void startEPT(String ... attributeValues) {
        this.currentI = this.nvl(attributeValues);
    }

    public void startOTHER() {
        this.currentI = null;
        this.currentX = null;
    }

    public Integer endBPT() {
        String x = this.pairTagsExternalMatch.get(this.currentI);
        if (x != null) {
            return Integer.parseInt(x);
        }
        return this.pairTags.get(this.currentI);
    }

    private Integer endExternalMatchTag() {
        if (this.currentX != null) {
            return Integer.parseInt(this.currentX);
        }
        return this.endOTHER();
    }

    public Integer endIT() {
        return this.endExternalMatchTag();
    }

    public Integer endPH() {
        return this.endExternalMatchTag();
    }

    public Integer endEPT() {
        String x = this.pairTagsExternalMatch.get(this.currentI);
        if (x != null) {
            return Integer.parseInt(x);
        }
        return this.pairTags.get(this.currentI);
    }

    public int endOTHER() {
        int result = this.tagIndex++;
        return result;
    }

    public int paired(String tagName, Tag.Type tagType) {
        switch (tagType) {
            case BEGIN: {
                int result = this.tagIndex++;
                this.cacheTagIndex(tagName, result);
                return result;
            }
            case END: {
                Integer index = this.getCachedTagIndex(tagName);
                if (index == null) {
                    index = this.tagIndex;
                    ++this.tagIndex;
                }
                return index;
            }
            case ALONE: {
                int result = this.tagIndex++;
                return result;
            }
        }
        throw new RuntimeException("Impossible tag type");
    }

    private void cacheTagIndex(String tagName, int result) {
        ArrayDeque<Integer> cache = this.pairedOtherTags.get(tagName);
        if (cache == null) {
            cache = new ArrayDeque();
            this.pairedOtherTags.put(tagName, cache);
        }
        cache.addFirst(result);
    }

    private Integer getCachedTagIndex(String tagName) {
        ArrayDeque<Integer> cache = this.pairedOtherTags.get(tagName);
        if (cache == null) {
            return null;
        }
        return cache.pollFirst();
    }

    public void setCurrentPos(String currentPos) {
        this.currentPos = currentPos;
    }

    public String getCurrentPos() {
        return this.currentPos;
    }

    public boolean getIsExternallyMatched() {
        return this.currentI != null && this.pairTagsExternalMatch.containsKey(this.currentI) || this.currentX != null;
    }

    private String nvl(String ... attributeValues) {
        String result = StringUtil.nvl(attributeValues);
        if (result == null) {
            throw new RuntimeException("Wrong index in inline tag");
        }
        return result;
    }
}

