/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.tokenizer;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.en.EnglishAnalyzer;
import org.apache.lucene.analysis.util.CharArraySet;
import org.omegat.core.Core;
import org.omegat.tokenizer.BaseTokenizer;
import org.omegat.tokenizer.Tokenizer;

@Tokenizer(languages={"en"}, isDefault=true)
public class LuceneEnglishTokenizer
extends BaseTokenizer {
    public static void loadPlugins() {
        Core.registerTokenizerClass(LuceneEnglishTokenizer.class);
    }

    public static void unloadPlugins() {
    }

    @Override
    protected TokenStream getTokenStream(String strOrig, boolean stemsAllowed, boolean stopWordsAllowed) throws IOException {
        if (stemsAllowed) {
            CharArraySet stopWords = stopWordsAllowed ? EnglishAnalyzer.getDefaultStopSet() : CharArraySet.EMPTY_SET;
            return new EnglishAnalyzer(stopWords).tokenStream("", (Reader)new StringReader(strOrig));
        }
        return this.getStandardTokenStream(strOrig);
    }
}

