/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Example;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.RuleMatch;

public class SentenceWhitespaceRule
extends org.languagetool.rules.SentenceWhitespaceRule {
    private static final Pattern NUMBER_REGEX = Pattern.compile("\\d+");
    private boolean prevSentenceEndsWithNumber = false;

    public SentenceWhitespaceRule(ResourceBundle messages) {
        super(messages);
        super.setCategory(Categories.MISC.getCategory(messages));
        this.setLocQualityIssueType(ITSIssueType.Whitespace);
        this.addExamplePair(Example.wrong((String)"Hier steht ein Satz.<marker>Das</marker> ist ein weiterer Satz."), Example.fixed((String)"Hier steht ein Satz.<marker> Das</marker> ist ein weiterer Satz."));
    }

    public String getId() {
        return "DE_SENTENCE_WHITESPACE";
    }

    public String getDescription() {
        return "Fehlendes Leerzeichen zwischen S\u00e4tzen oder nach Ordnungszahlen";
    }

    public String getMessage() {
        if (this.prevSentenceEndsWithNumber) {
            return "F\u00fcgen Sie nach Ordnungszahlen (1., 2. usw.) ein Leerzeichen ein";
        }
        return "F\u00fcgen Sie zwischen S\u00e4tzen ein Leerzeichen ein";
    }

    public RuleMatch[] match(AnalyzedSentence sentence) {
        AnalyzedTokenReadings[] tokens = sentence.getTokens();
        List<RuleMatch> matches = Arrays.asList(super.match(sentence));
        if (tokens.length > 1) {
            String prevLastToken = tokens[tokens.length - 2].getToken();
            this.prevSentenceEndsWithNumber = NUMBER_REGEX.matcher(prevLastToken).matches();
        }
        return this.toRuleMatchArray(matches);
    }

    public void reset() {
        super.reset();
        this.prevSentenceEndsWithNumber = false;
    }
}

