/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;

public abstract class AbstractWordCoherencyRule
extends Rule {
    private final Map<String, RuleMatch> shouldNotAppearWord = new HashMap<String, RuleMatch>();

    protected abstract Map<String, String> getWordMap();

    protected abstract String getMessage(String var1, String var2);

    public AbstractWordCoherencyRule(ResourceBundle messages) throws IOException {
        super.setCategory(Categories.MISC.getCategory(messages));
    }

    @Override
    public RuleMatch[] match(AnalyzedSentence sentence) {
        AnalyzedTokenReadings[] tokens;
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        for (AnalyzedTokenReadings tmpToken : tokens = sentence.getTokensWithoutWhitespace()) {
            String baseform;
            String token = tmpToken.getToken();
            List<AnalyzedToken> readings = tmpToken.getReadings();
            if (readings.size() > 0 && (baseform = readings.get(0).getLemma()) != null) {
                token = baseform;
            }
            if (this.shouldNotAppearWord.containsKey(token)) {
                RuleMatch otherMatch = this.shouldNotAppearWord.get(token);
                String otherSpelling = otherMatch.getMessage();
                String msg = this.getMessage(token, otherSpelling);
                RuleMatch ruleMatch = new RuleMatch(this, tmpToken.getStartPos(), tmpToken.getEndPos(), msg);
                ruleMatch.setSuggestedReplacement(otherSpelling);
                ruleMatches.add(ruleMatch);
                continue;
            }
            if (!this.getWordMap().containsKey(token)) continue;
            String shouldNotAppear = this.getWordMap().get(token);
            RuleMatch potentialRuleMatch = new RuleMatch(this, tmpToken.getStartPos(), tmpToken.getEndPos(), token);
            this.shouldNotAppearWord.put(shouldNotAppear, potentialRuleMatch);
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    @Override
    public void reset() {
        this.shouldNotAppearWord.clear();
    }
}

