/*
 * Decompiled with CFR 0.152.
 */
package io.github.eb4j.stardict;

import io.github.eb4j.stardict.DictionaryData;
import io.github.eb4j.stardict.IndexEntry;
import io.github.eb4j.stardict.SimpleLRUCache;
import io.github.eb4j.stardict.StarDictInfo;
import io.github.eb4j.stardict.StarDictLoader;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public abstract class StarDictDictionary
implements AutoCloseable {
    private final Map<IndexEntry, String> cache;
    private final boolean enableCache;
    protected final DictionaryData<IndexEntry> data;
    protected final StarDictInfo info;

    @Deprecated
    StarDictDictionary(DictionaryData<IndexEntry> data, StarDictInfo info, int maxsize, Duration duration) {
        this(data, info, 16, maxsize);
    }

    StarDictDictionary(DictionaryData<IndexEntry> data, StarDictInfo info, int initialCacheSize, int maximumCacheSize) {
        this.data = data;
        this.info = info;
        this.enableCache = maximumCacheSize > 0;
        this.cache = this.enableCache ? Collections.synchronizedMap(new SimpleLRUCache(initialCacheSize, maximumCacheSize)) : null;
    }

    public static StarDictDictionary loadDictionary(File ifoFile) throws Exception {
        Path dictPath;
        String f = ifoFile.getPath();
        if (f.endsWith(".ifo")) {
            f = f.substring(0, f.length() - ".ifo".length());
        }
        if ((dictPath = Paths.get(f + ".dict.dz", new String[0])).toString().endsWith(".dz")) {
            return StarDictLoader.load(ifoFile, 200);
        }
        return StarDictLoader.load(ifoFile, 100);
    }

    public static StarDictDictionary loadDictionary(File ifoFile, int cacheSize, Duration duration) throws Exception {
        return StarDictLoader.load(ifoFile, cacheSize);
    }

    public static StarDictDictionary loadDictionary(File ifoFile, int cacheSize) throws Exception {
        return StarDictLoader.load(ifoFile, cacheSize);
    }

    public String getDictionaryName() {
        return this.info.getBookName();
    }

    public String getDictionaryVersion() {
        return this.info.getVersion();
    }

    public StarDictInfo getInformation() {
        return this.info;
    }

    public List<Entry> readArticles(String word) {
        ArrayList<Entry> list = new ArrayList<Entry>();
        for (Map.Entry<String, IndexEntry> e : this.data.lookUp(word)) {
            Entry entry = new Entry(e.getKey(), this.getType(e.getValue()), this.getArticle(e.getValue()));
            list.add(entry);
        }
        return list;
    }

    public List<Entry> readArticlesPredictive(String word) {
        ArrayList<Entry> list = new ArrayList<Entry>();
        for (Map.Entry<String, IndexEntry> e : this.data.lookUpPredictive(word)) {
            Entry entry = new Entry(e.getKey(), this.getType(e.getValue()), this.getArticle(e.getValue()));
            list.add(entry);
        }
        return list;
    }

    private synchronized EntryType getType(IndexEntry starDictEntry) {
        return starDictEntry.getType();
    }

    private synchronized String getArticle(IndexEntry indexEntry) {
        if (this.enableCache) {
            String article = this.cache.get(indexEntry);
            if (article == null) {
                article = this.readArticle(indexEntry.getStart(), indexEntry.getLen());
                this.cache.put(indexEntry, article);
            }
            return article;
        }
        return this.readArticle(indexEntry.getStart(), indexEntry.getLen());
    }

    protected abstract String readArticle(long var1, int var3);

    @Override
    public void close() throws IOException {
        this.cache.clear();
    }

    public static class Entry {
        private final String word;
        private final EntryType type;
        private final String article;

        public Entry(String word, EntryType type, String article) {
            this.word = word;
            this.type = type;
            this.article = article;
        }

        public String getWord() {
            return this.word;
        }

        public EntryType getType() {
            return this.type;
        }

        public String getArticle() {
            return this.article;
        }
    }

    public static enum EntryType {
        MEAN('m'),
        PHONETIC('t'),
        PANGO('g'),
        XDXF('x'),
        YINBAO('y'),
        KINGSOFT('k'),
        MEDIAWIKI('w'),
        HTML('h'),
        WORDNET('n'),
        RESOURCE('r'),
        WAV('W'),
        PICTURE('P'),
        EXPERIMENTAL('X'),
        NOSAMETYPE('$');

        private final char typeValue;

        private EntryType(char type) {
            this.typeValue = type;
        }

        public char getTypeValue() {
            return this.typeValue;
        }

        public static EntryType getTypeByValue(char c) {
            for (EntryType t : EntryType.values()) {
                if (t.getTypeValue() != c) continue;
                return t;
            }
            return null;
        }
    }
}

