/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.visitors;

import java.util.Locale;
import org.htmlparser.Text;
import org.htmlparser.visitors.NodeVisitor;

public class StringFindingVisitor
extends NodeVisitor {
    private String stringToFind;
    private int foundCount;
    private boolean multipleSearchesWithinStrings;
    private Locale locale;

    public StringFindingVisitor(String stringToFind) {
        this(stringToFind, null);
    }

    public StringFindingVisitor(String stringToFind, Locale locale) {
        this.locale = null == locale ? Locale.ENGLISH : locale;
        this.stringToFind = stringToFind.toUpperCase(this.locale);
        this.foundCount = 0;
        this.multipleSearchesWithinStrings = false;
    }

    public void doMultipleSearchesWithinStrings() {
        this.multipleSearchesWithinStrings = true;
    }

    @Override
    public void visitStringNode(Text stringNode) {
        String stringToBeSearched = stringNode.getText().toUpperCase(this.locale);
        if (!this.multipleSearchesWithinStrings && stringToBeSearched.indexOf(this.stringToFind) != -1) {
            ++this.foundCount;
        } else if (this.multipleSearchesWithinStrings) {
            int index = -1;
            do {
                if ((index = stringToBeSearched.indexOf(this.stringToFind, index + 1)) == -1) continue;
                ++this.foundCount;
            } while (index != -1);
        }
    }

    public boolean stringWasFound() {
        return 0 != this.stringFoundCount();
    }

    public int stringFoundCount() {
        return this.foundCount;
    }
}

