; Beginning of Licence
;
; This software is licensed only for personal and educational use and
; not for the production of commercial software.  Modifications to this
; program are allowed but the resulting source must be annotated to
; indicate the nature of and the author of these changes.  
;
; Any modified source is bound by this licence and must remain available 
; as open source under the same conditions it was supplied and with this 
; licence at the top.

; This software is supplied AS IS without any warranty.  In no way shall 
; Mark Tarver or Lambda Associates be held liable for any damages resulting 
; from the use of this program.

; The terms of these conditions remain binding unless the individual 
; holds a valid license to use Qi commercially.  This license is found 
; in the final page of 'Functional Programming in Qi'.  In that event 
; the terms of that license apply to the license holder. 
;
; (c) copyright Mark Tarver, 2008
; End of Licence

(IN-PACKAGE :qi)

(DEFUN arity (FUNC) (GETHASH FUNC *arity* -1))

(DEFVAR *arity*
 (MAKE-HASH-TABLE :SIZE 300 :REHASH-SIZE 2 :REHASH-THRESHOLD 0.8))

(DEFUN store_arities (V5883)
 (COND ((NULL V5883) NIL)
  ((AND (CONSP V5883) (CONSP (CDR V5883)))
   (LET* ((V5884 (CDR V5883)))
    (store_arity (CAR V5883) (CAR V5884)) 
    (store_arities (CDR V5884))))
  (T (implementation_error 'store_arities))))

(DEFUN store_arity (FUNC N)
 (LET ((Arity (arity FUNC)))
  (IF (AND (NOT (= -1 Arity)) (NOT (= Arity N)))
   (warn (FORMAT NIL "Changing the arity of '~A' may cause errors~%" FUNC)))
  (SETF (GETHASH FUNC *arity*) N)))

(DEFUN warn (String)
  (COND ((EQ *strong-warning* 'true) (error String))
         (T (FORMAT T "======> Warning: ~A~%" String)))
  String)

(DEFUN strong-warning (Flag) 
  (COND ((EQ Flag '+) (SETQ *strong-warning* 'true))
        ((EQ Flag '-) (SETQ *strong-warning* 'false))
        (T (ERROR "stromg-warning expects either + or -~%"))))

(strong-warning '-)         

(DEFUN initialise_arity_table ()
 (store_arities
  '(and 2 append 2 apply 2 arity 1 assoc 2 assoc-type 2 boolean? 1 cd 1 character? 1 
    compile 2 complex? 1 concat 2 congruent? 2 cons 2 cons? 1 declare 2 debug 1 destroy 1 
    delete-file 1 difference 2 dump 1 echo 1 element? 2 empty? 1 eval 1 explode 1 fail-if 2
    fix 2 float? 1 freeze 1 fst 1 gensym 1 get-array 3 get-prop 3 qi_> 2 qi_>= 2 qi_= 2 
    head 1 if 3 if-with-checking 1 if-without-checking 1 integer? 1 inferences 1 
    intersection 2 length 1 lineread 0 load 1 qi_< 2 qi_<= 2 m-prolog 1 make-array 1 map 2
    mapcan 2 maxinferences 1 newsym 1 newvar 1 not 1 nth 2 number? 1 occurs-check 1
    occurrences 2 occurs-check 1 or 2 opaque 1 print 1 profile 1 profile-results 1 ps 1 put-array 3
    put-prop 3 random 1 quit 0 read-char 1 read-file-as-charlist 1 read-file 1
    read-chars-as-stringlist 2 rational? 1 real? 1 remove 2 reverse 1 round 1 save 0 snd 1
    set-comment-delimiter-start 1 set-comment-delimiter-end 1 set-escape-character 1 s-prolog 1 specialise 1 spy 1 speed 1 sqrt 1 step 1 string? 1 strong-warning 1 subst 3 
    sugar 3 sugarlist 1 symbol? 1 tail 1 tc 1 thaw 1 time 1 track 1 transparent 1 tuple? 1 tuple 2
    type 1 typecheck 3 unassoc-type 1 unprofile 1 unsugar 1 undebug 1 union 2 untrack 1 unspecialise 1 value 1
    variable? 1 version 1 warn 1 write-to-file 2 y-or-n? 1 + 2 * 2 / 2 - 2 == 2 @p 2 
    preclude 1 include 1 preclude-all-but 1 include-all-but 1 where 2)))

(initialise_arity_table)

