; Beginning of Licence
;
; This software is licensed only for personal and educational use and
; not for the production of commercial software.  Modifications to this
; program are allowed but the resulting source must be annotated to
; indicate the nature of and the author of these changes.  
;
; Any modified source is bound by this licence and must remain available 
; as open source under the same conditions it was supplied and with this 
; licence at the top.

; This software is supplied AS IS without any warranty.  In no way shall 
; Mark Tarver or Lambda Associates be held liable for any damages resulting 
; from the use of this program.

; The terms of these conditions remain binding unless the individual 
; holds a valid license to use Qi commercially.  This license is found 
; in the final page of 'Functional Programming in Qi'.  In that event 
; the terms of that license apply to the license holder. 
;
; (c) copyright Mark Tarver, 2008
; End of Licence

(IN-PACKAGE :qi)

(DEFUN speed (N)
  (IF (AND (INTEGERP N) (>= N 0) (< N 4))
      (SETQ *speed* N)	
      (ERROR "speed expects a value between 0 and 3.~%"))) 

(DEFUN optimise-lisp (V1 V2)
 (COND ((EQL 0 V1) V2) 
   ((EQL 1 V1) (optimise-calls (optimise-car-cdr V2)))
  ((EQL 2 V1)
   (optimise-car-cdr (optimise-type-declarations (insert-type-declarations (optimise-calls V2)))))
  ((EQL 3 V1) (optimise-type-declarations (insert-type-declarations
               (factorise (optimise-calls V2)))))
  (T (implementation_error 'optimise-lisp))))

(DEFUN optimise-calls (V12)
 (COND
  ((AND (CONSP V12) (EQ 'wrapper (CAR V12)) (CONSP (CDR V12))
    (CONSP (CAR (CDR V12))) (EQ 'number? (CAR (CAR (CDR V12))))
    (CONSP (CDR (CAR (CDR V12)))) (NULL (CDR (CDR (CAR (CDR V12)))))
    (NULL (CDR (CDR V12))))
   (LIST 'NUMBERP (optimise-calls (CAR (CDR (CAR (CDR V12)))))))
  ((AND (CONSP V12) (EQ 'wrapper (CAR V12)) (CONSP (CDR V12))
    (CONSP (CAR (CDR V12))) (EQ 'boolean? (CAR (CAR (CDR V12))))
    (CONSP (CDR (CAR (CDR V12)))) (NULL (CDR (CDR (CAR (CDR V12)))))
    (NULL (CDR (CDR V12))))
   (LIST 'MEMBER (optimise-calls (CAR (CDR (CAR (CDR V12)))))
    (LIST 'QUOTE (LIST 'true 'false))))
  ((AND (CONSP V12) (EQ 'wrapper (CAR V12)) (CONSP (CDR V12))
    (CONSP (CAR (CDR V12))) (EQ 'tuple? (CAR (CAR (CDR V12))))
    (CONSP (CDR (CAR (CDR V12)))) (NULL (CDR (CDR (CAR (CDR V12)))))
    (NULL (CDR (CDR V12))))
   (LIST 'TUPLE-P (optimise-calls (CAR (CDR (CAR (CDR V12)))))))
  ((AND (CONSP V12) (EQ 'wrapper (CAR V12)) (CONSP (CDR V12))
    (CONSP (CAR (CDR V12))) (EQ 'string? (CAR (CAR (CDR V12))))
    (CONSP (CDR (CAR (CDR V12)))) (NULL (CDR (CDR (CAR (CDR V12)))))
    (NULL (CDR (CDR V12))))
   (LIST 'STRINGP (optimise-calls (CAR (CDR (CAR (CDR V12)))))))
  ((AND (CONSP V12) (EQ 'wrapper (CAR V12)) (CONSP (CDR V12))
    (CONSP (CAR (CDR V12))) (EQ 'character? (CAR (CAR (CDR V12))))
    (CONSP (CDR (CAR (CDR V12)))) (NULL (CDR (CDR (CAR (CDR V12)))))
    (NULL (CDR (CDR V12))))
   (LIST 'CHARACTERP (optimise-calls (CAR (CDR (CAR (CDR V12)))))))
  ((AND (CONSP V12) (EQ 'wrapper (CAR V12)) (CONSP (CDR V12))
    (CONSP (CAR (CDR V12))) (EQ 'cons? (CAR (CAR (CDR V12))))
    (CONSP (CDR (CAR (CDR V12)))) (NULL (CDR (CDR (CAR (CDR V12)))))
    (NULL (CDR (CDR V12))))
   (LIST 'CONSP (optimise-calls (CAR (CDR (CAR (CDR V12)))))))
  ((AND (CONSP V12) (EQ 'wrapper (CAR V12)) (CONSP (CDR V12))
    (CONSP (CAR (CDR V12))) (EQ 'empty? (CAR (CAR (CDR V12))))
    (CONSP (CDR (CAR (CDR V12)))) (NULL (CDR (CDR (CAR (CDR V12)))))
    (NULL (CDR (CDR V12))))
   (optimise-calls (CONS 'NULL (CDR (CAR (CDR V12))))))
  ((AND (CONSP V12) (EQ 'wrapper (CAR V12)) (CONSP (CDR V12))
    (CONSP (CAR (CDR V12))) (EQ 'qi_> (CAR (CAR (CDR V12))))
    (CONSP (CDR (CAR (CDR V12)))) (CONSP (CDR (CDR (CAR (CDR V12)))))
    (NULL (CDR (CDR (CDR (CAR (CDR V12)))))) (NULL (CDR (CDR V12))))
   (optimise-calls (CONS (rfs ">") (CDR (CAR (CDR V12))))))
  ((AND (CONSP V12) (EQ 'wrapper (CAR V12)) (CONSP (CDR V12))
    (CONSP (CAR (CDR V12))) (EQ 'qi_>= (CAR (CAR (CDR V12))))
    (CONSP (CDR (CAR (CDR V12)))) (CONSP (CDR (CDR (CAR (CDR V12)))))
    (NULL (CDR (CDR (CDR (CAR (CDR V12)))))) (NULL (CDR (CDR V12))))
   (optimise-calls (CONS (rfs ">=") (CDR (CAR (CDR V12))))))
  ((AND (CONSP V12) (EQ 'wrapper (CAR V12)) (CONSP (CDR V12))
    (CONSP (CAR (CDR V12))) (EQ 'qi_<= (CAR (CAR (CDR V12))))
    (CONSP (CDR (CAR (CDR V12)))) (CONSP (CDR (CDR (CAR (CDR V12)))))
    (NULL (CDR (CDR (CDR (CAR (CDR V12)))))) (NULL (CDR (CDR V12))))
   (optimise-calls (CONS (rfs "<=") (CDR (CAR (CDR V12))))))
  ((AND (CONSP V12) (EQ 'wrapper (CAR V12)) (CONSP (CDR V12))
    (CONSP (CAR (CDR V12))) (EQ 'qi_< (CAR (CAR (CDR V12))))
    (CONSP (CDR (CAR (CDR V12)))) (CONSP (CDR (CDR (CAR (CDR V12)))))
    (NULL (CDR (CDR (CDR (CAR (CDR V12)))))) (NULL (CDR (CDR V12))))
   (optimise-calls (CONS (rfs "<") (CDR (CAR (CDR V12))))))
  ((AND (CONSP V12) (EQ 'cons (CAR V12)) (CONSP (CDR V12))
    (CONSP (CDR (CDR V12))) (NULL (CDR (CDR (CDR V12)))))
   (optimise-calls (CONS 'CONS (CDR V12))))
  ((AND (CONSP V12) (EQ 'append (CAR V12)))
   (optimise-calls (CONS 'APPEND (CDR V12))))
  ((AND (CONSP V12) (EQ 'reverse (CAR V12)) (CONSP (CDR V12))
    (NULL (CDR (CDR V12))))
   (optimise-calls (CONS 'REVERSE (CDR V12))))
  ((AND (CONSP V12) (EQ 'map (CAR V12)) (CONSP (CDR V12))
    (CONSP (CDR (CDR V12))) (NULL (CDR (CDR (CDR V12))))
    (EQL (arity (CAR (CDR V12))) 1))
   (optimise-calls (CONS 'MAPCAR (CDR V12))))
  ((AND (CONSP V12) (EQ 'value (CAR V12)) (CONSP (CDR V12))
    (CONSP (CAR (CDR V12))) (CONSP (CDR (CAR (CDR V12))))
    (NULL (CDR (CDR (CAR (CDR V12))))) (NULL (CDR (CDR V12)))
    (EQ 'QUOTE (CAR (CAR (CDR V12)))))
   (CAR (CDR (CAR (CDR V12)))))
  ((AND (CONSP V12) (EQ 'set (CAR V12)) (CONSP (CDR V12))
    (CONSP (CAR (CDR V12))) (CONSP (CDR (CAR (CDR V12))))
    (NULL (CDR (CDR (CAR (CDR V12))))) (CONSP (CDR (CDR V12)))
    (NULL (CDR (CDR (CDR V12)))) (EQ 'QUOTE (CAR (CAR (CDR V12)))))
   (LET* ((V13 (CDR V12)))
    (LIST 'SETQ (CAR (CDR (CAR V13))) (optimise-calls (CAR (CDR V13))))))
  ((AND (CONSP V12) (EQ 'wrapper (CAR V12)) (CONSP (CDR V12))
    (CONSP (CAR (CDR V12))) (EQ 'qi_= (CAR (CAR (CDR V12))))
    (CONSP (CDR (CAR (CDR V12)))) (CONSP (CDR (CDR (CAR (CDR V12)))))
    (NULL (CDR (CDR (CDR (CAR (CDR V12)))))) (NULL (CDR (CDR V12))))
   (optimise-calls (CONS 'ABSEQUAL (CDR (CAR (CDR V12))))))
  ((AND (CONSP V12) (CONSP (CDR V12)) (CONSP (CDR (CDR V12)))
    (CONSP (CAR (CDR (CDR V12)))) (CONSP (CDR (CAR (CDR (CDR V12)))))
    (NULL (CDR (CDR (CAR (CDR (CDR V12)))))) (NULL (CDR (CDR (CDR V12))))
    (EQ (CAR V12) 'ABSEQUAL) (EQ (CAR (CAR (CDR (CDR V12)))) 'QUOTE)
      (SYMBOLP (CAR (CDR (CAR (CDR (CDR V12)))))))
   (LET* ((V14 (CDR V12)))
    (CONS 'EQ (CONS (optimise-calls (CAR V14)) (CDR V14)))))
  ((AND (CONSP V12) (CONSP (CDR V12)) (CONSP (CAR (CDR V12)))
    (CONSP (CDR (CAR (CDR V12)))) (NULL (CDR (CDR (CAR (CDR V12)))))
    (CONSP (CDR (CDR V12))) (NULL (CDR (CDR (CDR V12))))
    (EQ (CAR V12) 'ABSEQUAL) (EQ (CAR (CAR (CDR V12))) 'QUOTE)
      (SYMBOLP (CAR (CDR (CAR (CDR V12))))))
   (LET* ((V15 (CDR V12)))
    (LIST 'EQ (optimise-calls (CAR (CDR V15))) (CAR V15))))
  ((AND (CONSP V12) (CONSP (CDR V12)) (CONSP (CDR (CDR V12)))
    (NULL (CDR (CDR (CDR V12))))
    (AND (EQ 'ABSEQUAL (CAR V12))
     (OR (CHARACTERP (CAR (CDR (CDR V12)))) (NUMBERP (CAR (CDR (CDR V12)))))))
   (LET* ((V16 (CDR V12)))
    (CONS 'EQL (CONS (optimise-calls (CAR V16)) (CDR V16)))))
  ((AND (CONSP V12) (CONSP (CDR V12)) (CONSP (CDR (CDR V12)))
    (NULL (CDR (CDR (CDR V12))))
    (AND (EQ 'ABSEQUAL (CAR V12))
     (OR (CHARACTERP (CAR (CDR V12))) (NUMBERP (CAR (CDR V12))))))
   (LET* ((V17 (CDR V12)))
    (LIST 'EQL (optimise-calls (CAR (CDR V17))) (CAR V17))))
  ((AND (CONSP V12) (EQ 'if (CAR V12)) (CONSP (CDR V12))
    (CONSP (CDR (CDR V12))) (CONSP (CDR (CDR (CDR V12))))
    (NULL (CDR (CDR (CDR (CDR V12))))))
   (LET* ((V18 (CDR V12)))
    (optimise-calls (CONS 'IF (CONS (LIST 'wrapper (CAR V18)) (CDR V18))))))
   ((AND (CONSP V12) (EQ 'wrapper (CAR V12)) (CONSP (CDR V12))
    (CONSP (CAR (CDR V12))) (EQ 'and (CAR (CAR (CDR V12))))
    (CONSP (CDR (CAR (CDR V12)))) (CONSP (CDR (CDR (CAR (CDR V12)))))
    (NULL (CDR (CDR (CDR (CAR (CDR V12)))))) (NULL (CDR (CDR V12))))
   (LET ((X5 (CDR V12)))
    (optimise-calls
     (CONS 'AND
      (CONS (CONS 'wrapper (CONS (CAR (CDR (CAR X5))) NIL))
       (CONS (CONS 'wrapper (CDR (CDR (CAR X5)))) NIL))))))
  ((AND (CONSP V12) (EQ 'wrapper (CAR V12)) (CONSP (CDR V12))
    (CONSP (CAR (CDR V12))) (EQ 'or (CAR (CAR (CDR V12))))
    (CONSP (CDR (CAR (CDR V12)))) (CONSP (CDR (CDR (CAR (CDR V12)))))
    (NULL (CDR (CDR (CDR (CAR (CDR V12)))))) (NULL (CDR (CDR V12))))
   (LET ((X6 (CDR V12)))
    (optimise-calls
     (CONS 'OR
      (CONS (CONS 'wrapper (CONS (CAR (CDR (CAR X6))) NIL))
       (CONS (CONS 'wrapper (CDR (CDR (CAR X6)))) NIL))))))
  ((AND (CONSP V12) (EQ 'do (CAR V12)))
   (CONS 'PROGN (MAPCAR 'optimise-calls (CDR V12))))
  ((AND (CONSP V12) (EQ '+ (CAR V12)) (CONSP (CDR V12)) (CONSP (CDR (CDR V12)))
    (EQL 1 (CAR (CDR (CDR V12)))) (NULL (CDR (CDR (CDR V12)))))
   (LIST '1+ (optimise-calls (CAR (CDR V12)))))
  ((AND (CONSP V12) (EQ '+ (CAR V12)) (CONSP (CDR V12)) (EQL 1 (CAR (CDR V12)))
    (CONSP (CDR (CDR V12))) (NULL (CDR (CDR (CDR V12)))))
   (LIST '1+ (optimise-calls (CAR (CDR (CDR V12))))))
  ((AND (CONSP V12) (EQ '- (CAR V12)) (CONSP (CDR V12)) (CONSP (CDR (CDR V12)))
    (EQL 1 (CAR (CDR (CDR V12)))) (NULL (CDR (CDR (CDR V12)))))
   (LIST '1- (optimise-calls (CAR (CDR V12)))))
  ((CONSP V12) (MAPCAR 'optimise-calls V12)) 
  (T V12)))

(DEFUN rfs (V15) (READ-FROM-STRING V15))

(DEFUN optimise-car-cdr (V16)
 (COND
  ((AND (CONSP V16) (CONSP (CDR V16)) (CONSP (CDR (CDR V16)))
    (CONSP (CDR (CDR (CDR V16)))) (CONSP (CAR (CDR (CDR (CDR V16)))))
    (NULL (CDR (CDR (CDR (CDR V16)))))
    (EQ 'COND (CAR (CAR (CDR (CDR (CDR V16)))))))
   (LET* ((V17 (CDR V16)) (V18 (CDR V17)) (V19 (CDR V18)) (V20 (CAR V19)))
    (LIST (CAR V16) (CAR V17) (CAR V18)
     (CONS (CAR V20) (THE LIST (MAPCAR 'occ (CDR V20)))))))
  (T V16)))

(DEFUN occ (V23)
 (COND
  ((AND (CONSP V23) (CONSP (CDR V23)) (NULL (CDR (CDR V23))))
   (LET* ((V24 (CAR V23))) (LIST V24 (occ1 V24 NIL (CAR (CDR V23))))))
  (T (implementation_error 'occ))))

(DEFUN occ1 (V5 V6 V7)
 (COND ((AND (CONSP V5) (EQ 'AND (CAR V5))) (occ1 (CDR V5) V6 V7))
  ((AND (CONSP V5) (CONSP (CAR V5)) (CONSP (CDR (CAR V5)))
    (NULL (CDR (CDR (CAR V5)))) (EQ 'CONSP (CAR (CAR V5))))
   (LET* ((V8 (CAR V5)) (V9 (CDR V8)))
    (occ1 (CDR V5) (CONS (CONS 'CDR V9) (CONS (CONS 'CAR V9) V6)) V7)))
  ((AND (CONSP V5) (CONSP (CDR V5)) (NULL (CDR (CDR V5))) (EQ 'CONSP (CAR V5)))
   (LET* ((V10 (CDR V5)))
    (occ1 '_ (CONS (CONS 'CDR V10) (CONS (CONS 'CAR V10) V6)) V7)))
  (T
   (LET ((Assignments (remove-if-not-rpted (REVERSE V6) V7)))
    (make-local-assignments Assignments V7)))))

(DEFUN remove-if-not-rpted (V36 V37)
 (COND ((NULL V36) NIL)
  ((CONSP V36)
   (LET* ((V38 (CAR V36)) (V39 (CDR V36)))
    (if (rpted? V38 V37) (CONS V38 (remove-if-not-rpted V39 V37))
     (remove-if-not-rpted V39 V37))))
  (T (implementation_error 'remove-if-not-rpted))))

(DEFUN rpted? (V40 V41)
 (THE SYMBOL (qi_> (THE NUMBER (occurrences V40 V41)) 1)))

(DEFUN occurrences (V53 V54)
 (COND ((ABSEQUAL V53 V54) 1)
  ((CONSP V54)
   (THE NUMBER
    (+ (THE NUMBER (occurrences V53 (CAR V54)))
     (THE NUMBER (occurrences V53 (CDR V54))))))
  ((TUPLE-P V54)
   (THE NUMBER
    (+ (THE NUMBER (occurrences V53 (fst V54)))
     (THE NUMBER (occurrences V53 (snd V54))))))
  (T 0)))

(DEFUN make-local-assignments (V1 V2)
 (COND ((NULL V1) V2)
  (T
   (LET ((Variables (MAPCAR #'(LAMBDA (X) (gensym "X")) V1)))
    (mla-help Variables V1 V2)))))

(DEFUN mla-help (V3 V4 V5)
 (COND ((AND (NULL V3) (NULL V4)) V5)
  ((AND (CONSP V3) (CONSP V4))
   (LET* ((V6 (CAR V3)) (V7 (CAR V4)))
    (LIST 'LET (LIST (LIST V6 V7))
     (mla-help (CDR V3) (subst V6 V7 (CDR V4)) (subst V6 V7 V5)))))
  (T (implementation_error 'mla-help))))

(DEFUN insert-type-declarations (V1)
 (COND
  ((AND (CONSP V1) (CONSP (CDR V1)) (CONSP (CDR (CDR V1)))
    (CONSP (CDR (CDR (CDR V1)))) (NULL (CDR (CDR (CDR (CDR V1)))))
    (EQ 'DEFUN (CAR V1)))
   (LET* ((V2 (CDR V1)) (V3 (CAR V2)) (V4 (CDR V2)) (V5 (CAR V4)))
    (LET ((Type (type-of-function V3)))
     (LET ((ParamTypes (the Type V5)))
      (LET
       ((NewCode
         (insert-type-declarations
          (insert-type-params ParamTypes (CAR (CDR V4))))))
       (LIST (CAR V1) V3 V5 NewCode))))))
  ((CONSP V1)
   (LET* ((V6 (CAR V1)) (V7 (CDR V1)))
    (LET ((Type (type-of-function V6)))
     (IF (NULL Type)
      (CONS V6 (THE LIST (MAPCAR 'insert-type-declarations V7)))
      (optimise-F (arity V6) Type
       (CONS V6 (the Type (THE LIST (MAPCAR 'insert-type-declarations V7)))))))))
  (T V1)))

(DEFUN insert-type-params (V2542 V2543)
 (COND ((NULL V2542) V2543)
  ((AND (CONSP V2542) (CONSP (CAR V2542)) (CONSP (CDR (CAR V2542)))
    (CONSP (CDR (CDR (CAR V2542)))) (NULL (CDR (CDR (CDR (CAR V2542)))))
    (EQ (CAR (CAR V2542)) 'THE))
   (LET ((X2544 (CAR V2542)))
    (insert-type-params (CDR V2542)
     (subst X2544 (CAR (CDR (CDR X2544))) V2543))))
  ((CONSP V2542) (insert-type-params (CDR V2542) V2543))
  (T (implementation_error 'insert-type-params))))

(DEFUN optimise-F (V24 V25 V26)
 (COND
  ((EQL 0 V24)
   (LET ((B (find-assoc-type V25)))
    (IF (NULL B) V26 (LIST 'THE B V26))))
  ((AND (CONSP V25) (CONSP (CDR V25)) (EQ '--> (CAR (CDR V25)))
    (CONSP (CDR (CDR V25))) (NULL (CDR (CDR (CDR V25)))))
   (optimise-F (1- V24) (CAR (CDR (CDR V25))) V26))
  (T V26)))

(DEFUN type-of-function (V28)
 (LET ((Signature (GETHASH V28 *signatures*)))
  (IF (NULL Signature) NIL (FUNCALL Signature))))

(DEFUN the (V43 V44)
 (COND ((NULL V44) NIL) ((NULL V43) NIL)
  ((AND (CONSP V43) (CONSP (CDR V43)) (EQ '--> (CAR (CDR V43)))
    (CONSP (CDR (CDR V43))) (NULL (CDR (CDR (CDR V43)))) (CONSP V44))
   (LET*
    ((V45 (CAR V44)) (V46 (CDR V43)) (V47 (CDR V44)) (V48 (CDR V46))
     (V49 (CAR V48)))
    (LET ((C (find-assoc-type (CAR V43))))
     (IF (NULL C) (CONS V45 (the V49 V47))
      (CONS (LIST 'THE C V45) (the V49 V47))))))
  (T (implementation_error 'the))))

(DEFUN find-assoc-type (A) (CDR (assoc A *assoctypes*)))

(SETQ *assoctypes* '((list . LIST) (symbol . SYMBOL) (variable . SYMBOL) 
			         (character . CHARACTER) (boolean . SYMBOL) 
				     (string . STRING) (number . NUMBER)))

(DEFUN factorise (V106)
 (COND
  ((AND (CONSP V106) (CONSP (CDR V106)) (CONSP (CDR (CDR V106)))
    (CONSP (CDR (CDR (CDR V106)))) (CONSP (CAR (CDR (CDR (CDR V106)))))
    (NULL (CDR (CDR (CDR (CDR V106)))))
    (EQ 'COND (CAR (CAR (CDR (CDR (CDR V106)))))))
   (LET* ((V107 (CDR V106)) (V108 (CDR V107)))
    (LIST (CAR V106) (CAR V107) (CAR V108)
     (LIST 'BLOCK NIL (factor (CDR (CAR (CDR V108))))))))
  (T V106)))

(DEFUN factor (V110)
 (COND
  ((AND (CONSP V110) (CONSP (CAR V110)) (CONSP (CDR (CAR V110)))
    (NULL (CDR (CDR (CAR V110))))
    (OR (EQ T (CAR (CAR V110))) (ABSEQUAL (LIST 'AND) (CAR (CAR V110)))))
   (return-return(CAR (CDR (CAR V110)))))
  ((AND (CONSP V110) (CONSP (CAR V110)) (CONSP (CAR (CAR V110)))
    (CONSP (CDR (CAR (CAR V110)))) (CONSP (CDR (CAR V110)))
    (NULL (CDR (CDR (CAR V110)))) (EQ 'AND (CAR (CAR (CAR V110)))))
   (LET*
    ((V111 (CAR V110)) (V112 (CAR V111)) (V113 (CDR V112)) (V114 (CAR V113)))
    (LET ((Partition (part V114 V110 NIL)))
     (LET ((PattP (fst Partition)))
      (LET ((ExclP (snd Partition)))
       (if (THE SYMBOL (empty? PattP))
        (LIST 'IF V112 (return-return (CAR (CDR V111))) (factor (CDR V110)))
        (LET ((Tag (gensym "tag")))
         (LET
          ((FactPattP (factor (APPEND PattP (LIST (LIST 'T (LIST 'GO Tag)))))))
          (LET ((FactExlP (factor ExclP)))
           (if (reachable? Tag FactPattP) (tag V114 FactPattP Tag FactExlP)
            (LIST 'IF V114 (turbo-optimise-car/cdr V114 FactPattP)
             FactExlP)))))))))))
  ((AND (CONSP V110) (CONSP (CAR V110)) (CONSP (CDR (CAR V110)))
    (NULL (CDR (CDR (CAR V110)))))
   (LET* ((V115 (CAR V110)))
    (LIST 'IF (CAR V115) (return-return (CAR (CDR V115))) (factor (CDR V110)))))
  (T (implementation_error 'factor))))

(DEFUN tag (V117 V118 V119 V120)
 (COND
  ((AND (CONSP V120) (CONSP (CDR V120)) (NULL (CDR (CDR V120)))
    (EQ 'GO (CAR V120)))
   (LIST 'IF V117
    (turbo-optimise-car/cdr V117 (redirect-tag V119 (CAR (CDR V120)) V118))
    V120))
  (T
   (LIST 'TAGBODY (LIST 'IF V117 (turbo-optimise-car/cdr V117 V118)) V119
    V120))))

(DEFUN redirect-tag (V130 V131 V132)
 (COND
  ((AND (CONSP V132) (CONSP (CDR V132)) (NULL (CDR (CDR V132)))
    (AND (ABSEQUAL V130 (CAR (CDR V132))) (EQ 'GO (CAR V132))))
   (LIST (CAR V132) V131))
  ((CONSP V132)
   (THE LIST (MAPCAR #'(LAMBDA (Z) (redirect-tag V130 V131 Z)) V132)))
  (T V132)))

(DEFUN turbo-optimise-car/cdr (V139 V140)
 (COND
  ((AND (CONSP V139) (CONSP (CDR V139)) (NULL (CDR (CDR V139)))
    (EQ 'CONSP (CAR V139)))
   (LET* ((V141 (CDR V139)))
    (occ-help (CAR V141) V140
     (THE SYMBOL (qi_> (THE NUMBER (occurrences (CONS 'CAR V141) V140)) 1))
     (THE SYMBOL (qi_> (THE NUMBER (occurrences (CONS 'CDR V141) V140)) 1)))))
  (T V140)))

(DEFUN occ-help (V158 V159 V160 V161)
 (COND
  ((AND (EQ 'true V160) (EQ 'true V161))
   (LET ((Car (gensym "Car")))
    (LET ((Cdr (gensym "Cdr")))
     (LIST 'LET (LIST (LIST Car (LIST 'CAR V158)) (LIST Cdr (LIST 'CDR V158)))
      (subst Cdr (LIST 'CDR V158) (subst Car (LIST 'CAR V158) V159))))))
  ((AND (EQ 'true V160) (EQ 'false V161))
   (LET ((Car (gensym "Car")))
    (LIST 'LET (LIST (LIST Car (LIST 'CAR V158)))
     (subst Car (LIST 'CAR V158) V159))))
  ((AND (EQ 'false V160) (EQ 'true V161))
   (LET ((Cdr (gensym "Cdr")))
    (LIST 'LET (LIST (LIST Cdr (LIST 'CDR V158)))
     (subst Cdr (LIST 'CDR V158) V159))))
  (T V159)))

(DEFUN reachable? (V171 V172)
 (COND
  ((AND (CONSP V172) (CONSP (CDR V172)) (NULL (CDR (CDR V172)))
    (AND (ABSEQUAL V171 (CAR (CDR V172))) (EQ 'GO (CAR V172))))
   'true)
  ((CONSP V172)
   (THE SYMBOL (or (reachable? V171 (CAR V172)) (reachable? V171 (CDR V172)))))
  (T 'false)))

(DEFUN return-return (V173)
 (COND
  ((AND (CONSP V173) (CONSP (CDR V173)) (NULL (CDR (CDR V173)))
    (EQ 'GO (CAR V173)))
   V173)
  (T (LIST 'RETURN V173))))

(DEFUN part (V175 V176 V177)
 (COND
  ((AND (CONSP V176) (CONSP (CAR V176)) (CONSP (CAR (CAR V176)))
    (CONSP (CDR (CAR (CAR V176)))) (CONSP (CDR (CAR V176)))
    (NULL (CDR (CDR (CAR V176))))
    (AND (ABSEQUAL V175 (CAR (CDR (CAR (CAR V176)))))
     (EQ 'AND (CAR (CAR (CAR V176))))))
   (LET* ((V178 (CAR V176)) (V179 (CAR V178)) (V180 (CDR V179)))
    (part (CAR V180) (CDR V176)
     (CONS (CONS (CONS (CAR V179) (CDR V180)) (CDR V178)) V177))))
  (T (@p (REVERSE V177) V176))))

(DEFUN optimise-type-declarations (V25)
 (COND
  ((AND (CONSP V25) (CONSP (CDR V25)) (CONSP (CDR (CDR V25)))
    (CONSP (CAR (CDR (CDR V25)))) (CONSP (CDR (CAR (CDR (CDR V25)))))
    (CONSP (CDR (CDR (CAR (CDR (CDR V25))))))
    (NULL (CDR (CDR (CDR (CAR (CDR (CDR V25))))))) (NULL (CDR (CDR (CDR V25))))
    (AND (ABSEQUAL (CAR (CDR V25)) (CAR (CDR (CAR (CDR (CDR V25))))))
     (AND (ABSEQUAL (CAR V25) (CAR (CAR (CDR (CDR V25)))))
      (EQ 'THE (CAR (CAR (CDR (CDR V25))))))))
   (optimise-type-declarations (CAR (CDR (CDR V25)))))
  ((AND (CONSP V25) (CONSP (CDR V25)) (CONSP (CAR (CDR V25)))
    (CONSP (CDR (CAR (CDR V25)))) (CONSP (CDR (CDR (CAR (CDR V25)))))
    (NULL (CDR (CDR (CDR (CAR (CDR V25)))))) (CONSP (CDR (CDR V25)))
    (EQL 0 (CAR (CDR (CDR V25)))) (NULL (CDR (CDR (CDR V25))))
    (AND (EQ 'EQL (CAR V25)) (EQ 'NUMBER (CAR (CDR (CAR (CDR V25)))))))
   (optimise-type-declarations (LIST 'ZEROP (CAR (CDR V25)))))
  ((AND (CONSP V25) (CONSP (CDR V25)) (EQL 0 (CAR (CDR V25)))
    (CONSP (CDR (CDR V25))) (CONSP (CAR (CDR (CDR V25))))
    (CONSP (CDR (CAR (CDR (CDR V25)))))
    (CONSP (CDR (CDR (CAR (CDR (CDR V25))))))
    (NULL (CDR (CDR (CDR (CAR (CDR (CDR V25))))))) (NULL (CDR (CDR (CDR V25))))
    (AND (EQ 'EQL (CAR V25)) (EQ 'NUMBER (CAR (CDR (CAR (CDR (CDR V25))))))))
   (optimise-type-declarations (CONS 'ZEROP (CDR (CDR V25)))))
  ((AND (CONSP V25) (CONSP (CDR V25)) (CONSP (CAR (CDR V25)))
    (CONSP (CDR (CAR (CDR V25)))) (CONSP (CDR (CDR (CAR (CDR V25)))))
    (NULL (CDR (CDR (CDR (CAR (CDR V25)))))) (CONSP (CDR (CDR V25)))
    (NULL (CDR (CDR (CDR V25))))
    (AND (EQ 'EQL (CAR V25)) (EQ 'NUMBER (CAR (CDR (CAR (CDR V25)))))))
   (LET* ((V26 (CDR V25)) (V27 (CAR V26)))
    (optimise-type-declarations
     (LIST (rfs "=") V27 (CONS (CAR V27) (CONS (CAR (CDR V27)) (CDR V26)))))))
  ((AND (CONSP V25) (CONSP (CDR V25)) (CONSP (CDR (CDR V25)))
    (CONSP (CAR (CDR (CDR V25)))) (CONSP (CDR (CAR (CDR (CDR V25)))))
    (CONSP (CDR (CDR (CAR (CDR (CDR V25))))))
    (NULL (CDR (CDR (CDR (CAR (CDR (CDR V25))))))) (NULL (CDR (CDR (CDR V25))))
    (AND (EQ 'EQL (CAR V25)) (EQ 'NUMBER (CAR (CDR (CAR (CDR (CDR V25))))))))
   (LET* ((V28 (CDR V25)) (V29 (CDR V28)) (V30 (CAR V29)))
    (optimise-type-declarations
     (LIST (rfs "=") V30 (LIST (CAR V30) (CAR (CDR V30)) (CAR V28))))))
  ((AND (CONSP V25) (CONSP (CDR V25)) (CONSP (CAR (CDR V25)))
    (CONSP (CDR (CAR (CDR V25)))) (CONSP (CDR (CDR (CAR (CDR V25)))))
    (NULL (CDR (CDR (CDR (CAR (CDR V25)))))) (CONSP (CDR (CDR V25)))
    (NULL (CDR (CDR (CDR V25))))
    (AND (EQ 'ABSEQUAL (CAR V25)) (EQ 'CHARACTER (CAR (CDR (CAR (CDR V25)))))))
   (LET* ((V31 (CDR V25)) (V32 (CAR V31)))
    (optimise-type-declarations
     (CONS 'CHAR-EQUAL
      (CONS (CONS (CAR V32) (CONS 'CHARACTER (CDR (CDR V32)))) (CDR V31))))))
  ((AND (CONSP V25) (CONSP (CDR V25)) (CONSP (CDR (CDR V25)))
    (CONSP (CAR (CDR (CDR V25)))) (CONSP (CDR (CAR (CDR (CDR V25)))))
    (CONSP (CDR (CDR (CAR (CDR (CDR V25))))))
    (NULL (CDR (CDR (CDR (CAR (CDR (CDR V25))))))) (NULL (CDR (CDR (CDR V25))))
    (AND (EQ 'ABSEQUAL (CAR V25))
     (EQ 'CHARACTER (CAR (CDR (CAR (CDR (CDR V25))))))))
   (optimise-type-declarations (CONS 'CHAR-EQUAL (CDR V25))))
  ((AND (CONSP V25) (CONSP (CDR V25)) (CONSP (CAR (CDR V25)))
    (CONSP (CDR (CAR (CDR V25)))) (CONSP (CDR (CDR (CAR (CDR V25)))))
    (NULL (CDR (CDR (CDR (CAR (CDR V25)))))) (CONSP (CDR (CDR V25)))
    (NULL (CDR (CDR (CDR V25))))
    (AND (EQ 'ABSEQUAL (CAR V25)) (EQ 'STRING (CAR (CDR (CAR (CDR V25)))))))
   (optimise-type-declarations (CONS 'STRING-EQUAL (CDR V25))))
  ((AND (CONSP V25) (CONSP (CDR V25)) (CONSP (CDR (CDR V25)))
    (CONSP (CAR (CDR (CDR V25)))) (CONSP (CDR (CAR (CDR (CDR V25)))))
    (CONSP (CDR (CDR (CAR (CDR (CDR V25))))))
    (NULL (CDR (CDR (CDR (CAR (CDR (CDR V25))))))) (NULL (CDR (CDR (CDR V25))))
    (AND (EQ 'ABSEQUAL (CAR V25))
     (EQ 'STRING (CAR (CDR (CAR (CDR (CDR V25))))))))
   (optimise-type-declarations (CONS 'STRING-EQUAL (CDR V25))))
  ((AND (CONSP V25) (CONSP (CDR V25)) (CONSP (CDR (CDR V25)))
    (CONSP (CAR (CDR (CDR V25)))) (CONSP (CDR (CAR (CDR (CDR V25)))))
    (CONSP (CDR (CDR (CAR (CDR (CDR V25))))))
    (NULL (CDR (CDR (CDR (CAR (CDR (CDR V25))))))) (NULL (CDR (CDR (CDR V25))))
    (AND (EQ 'ABSEQUAL (CAR V25))
     (EQ 'SYMBOL (CAR (CDR (CAR (CDR (CDR V25))))))))
   (optimise-type-declarations (CONS 'EQ (CDR V25))))
  ((AND (CONSP V25) (CONSP (CDR V25)) (CONSP (CDR (CDR V25)))
    (CONSP (CAR (CDR (CDR V25)))) (CONSP (CDR (CAR (CDR (CDR V25)))))
    (CONSP (CDR (CDR (CAR (CDR (CDR V25))))))
    (NULL (CDR (CDR (CDR (CAR (CDR (CDR V25))))))) (NULL (CDR (CDR (CDR V25))))
    (AND (EQ 'ABSEQUAL (CAR V25))
     (EQ 'SYMBOL (CAR (CDR (CAR (CDR (CDR V25))))))))
   (optimise-type-declarations (CONS 'EQ (CDR V25))))
  ((AND (CONSP V25) (CONSP (CDR V25)) (CONSP (CDR (CDR V25)))
    (CONSP (CAR (CDR (CDR V25)))) (CONSP (CDR (CAR (CDR (CDR V25)))))
    (CONSP (CDR (CDR (CAR (CDR (CDR V25))))))
    (NULL (CDR (CDR (CDR (CAR (CDR (CDR V25))))))) (NULL (CDR (CDR (CDR V25))))
    (AND (EQ 'ABSEQUAL (CAR V25))
     (EQ 'NUMBER (CAR (CDR (CAR (CDR (CDR V25))))))))
   (optimise-type-declarations (CONS (rfs "=") (CDR V25))))
  ((AND (CONSP V25) (CONSP (CDR V25)) (CONSP (CDR (CDR V25)))
    (CONSP (CAR (CDR (CDR V25)))) (CONSP (CDR (CAR (CDR (CDR V25)))))
    (CONSP (CDR (CDR (CAR (CDR (CDR V25))))))
    (NULL (CDR (CDR (CDR (CAR (CDR (CDR V25))))))) (NULL (CDR (CDR (CDR V25))))
    (AND (EQ 'ABSEQUAL (CAR V25))
     (EQ 'NUMBER (CAR (CDR (CAR (CDR (CDR V25))))))))
   (optimise-type-declarations (CONS (rfs "=") (CDR V25))))
  ((CONSP V25) (MAPCAR 'optimise-type-declarations V25)) 
  (T V25)))

(DEFUN assoc-type (Qi Lisp) (PUSH (CONS Qi Lisp) *assoctypes*) Qi)

(DEFUN unassoc-type (Qi) 
  (SETQ *assoctypes* (REMOVE-IF #'(LAMBDA (X) (EQ (CAR X) Qi)) *assoctypes*))
  Qi)