/*
HMTabItemGroupView.h

Author: Makoto Kinoshita

Copyright 2004-2006 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/

#import <Cocoa/Cocoa.h>

// Constants
extern float    HMTabViewThumbnailPaddingTop;
extern float    HMTabViewThumbnailPaddingLeft;
extern float    HMTabViewThumbnailPaddingRight;
extern float    HMTabViewThumbnailPaddingBottom;

extern NSString*    HMTabItemViewPboardType;

@class HMMouseOverButton;
@class HMTabItemView;
@class HMTabView;
@class HMTabViewItem;
@class HMProgressIndicator;

@interface HMTabClipButton : NSPopUpButton
{
}
@end

@interface HMTabItemGroupView : NSView
{
    HMTabView*          _tabView;
    NSMutableArray*     _tabItemViews;
    HMMouseOverButton*  _addTabButton;
    HMTabClipButton*    _clipButton;
    
    NSSize              _preferredSize;
    
    NSControlSize       _size;
    
    NSRect              _oldFrame; // For split view size change
    NSPoint             _trackingStartPoint;
    HMTabItemView*      _draggingItemView;
    
    NSAnimation*        _animation;
    int                 _animationIndex;
    NSMutableArray*     _fadeInAnimations;
    NSMutableArray*     _fadeOutAnimations;
    
    id                  _delegate;
}

// Initialize
- (id)initWithFrame:(NSRect)frame tabView:(HMTabView*)tabView;

// Tab view item
- (void)addTabViewItems:(NSArray*)tabViewItems animation:(BOOL)animation;
- (void)insertTabViewItem:(HMTabViewItem*)tabViewItem atIndex:(unsigned int)index;
- (void)removeTabViewItems:(NSArray*)tabViewItems animation:(BOOL)animation;

- (int)indexOfCloseButton:(NSButton*)closeButton;

// Size
- (NSControlSize)size;
- (void)setSize:(NSControlSize)size;
- (NSSize)preferredSize;
- (float)preferredWideWithHigh:(float)high;
- (float)minTabWide;
- (float)maxTabWide;
- (float)minTabHigh;
- (float)maxTabHigh;

// Drawing
- (void)updateTabFrames;
- (BOOL)isTabItemVisibleAtIndex:(int)index;

// Dragging
- (void)addDraggedTypes:(NSArray*)pboardTypes;
- (void)dragTabItemView:(HMTabItemView*)tabItemView event:(NSEvent*)event;

// Delegate
- (id)delegate;
- (void)setDelegate:(id)delegate;

@end

@interface NSObject (HMTabItemGroupViewDelegate)
- (NSMenu*)tabItemGroupView:(HMTabItemGroupView*)view menuForEvent:(NSEvent*)event;
@end
