# Part of the A-A-P recipe executive: remember the work specified in the recipe

# Copyright (C) 2002-2003 Stichting NLnet Labs
# Permission to copy and use this file is specified in the file COPYING.
# If this file is missing you can find it here: http://www.a-a-p.org/COPYING

#
# Global variables, can be used anywhere
#
# Always use "import Global" and prepend "Global.", so that it's clear a global
# variable is being used.
#

# recdict with global variables for current (build) commands.  Set before
# executing the build commands.
globals = None

# arguments from the command line
cmd_args = None

# The directory in which A-A-P places its files.
# It used to be called differently, it is automatically renamed for a while.
aap_dirname = "AAPDIR"

# directory where the A-A-P modules are
aap_rootdir = None

# directory where package binaries are stored ("bin" subdir in aap_rootdir)
aap_bindir = None

# directory where tools are stored ("tools" subdir in aap_rootdir)
aap_toolsdir = None

# directory where modules are stored ("modules" subdir in aap_rootdir)
aap_modulesdir = None

def set_aap_rootdir(dir):
    """
    Set aap_rootdir to "dir".
    Set aap_bindir to "bin" below aap_rootdir.
    Set aap_toolsdir to "tools" below aap_rootdir.
    Set aap_modulesdir to "modules" below aap_rootdir.
    """
    import os.path
    global aap_rootdir, aap_bindir, aap_toolsdir, aap_modulesdir

    aap_rootdir = dir
    aap_bindir = os.path.join(dir, "bin")
    aap_toolsdir = os.path.join(dir, "tools")
    aap_modulesdir = os.path.join(dir, "modules")


# Ugly global variable to store results of system commands for configure tests.
sys_cmd_log = None


# Forced building, ignore --nobuild and --force arguments.  Used for updating
# dependencies.
force_build = 0

# all standard targets that are virtual
virtual_targets = [
                    "add",
                    "all",
                    "build",
                    "check",
                    "checkin",
                    "checkout",
                    "clean",
                    "cleanmore",
                    "cleanALL",
                    "commit",
                    "distclean",
                    "extract",
                    "fetch",
                    "finally",
                    "install",
                    "patch",
                    "publish",
                    "reference",
                    "remove",
                    "revise",
                    "test",
                    "tryout",
                    "unlock",
                    "update",
                  ]

# Set to zero when executing build commands.  Used in Process() to decide
# whether toplevel commands are allowed.
at_toplevel = 1

# vim: set sw=4 et sts=4 tw=79 fo+=l:
