# Part of the A-A-P recipe executive: Testing of :import

# Copyright (C) 2002-2003 Stichting NLnet Labs
# Permission to copy and use this file is specified in the file COPYING.
# If this file is missing you can find it here: http://www.a-a-p.org/COPYING

import sys, os, re

def runaap(args):
    return os.system("%s ..%sMain.py %s" % (sys.argv[1], os.sep, args))

os.chdir("rectest")

# Create a recipe, run it and check the output.
# Checks expanding $VAR.
rec = "rectest.aap"
out = "rectest.out"

f = open(rec, "w")
f.write("""
:import rectest
:print $m_rectest.DMD
:print `m_rectest.DMD`
:print `m_rectest.testfunc()`
:import rectest
all:
    m_rectest += crash
""")
f.close()

res = runaap("-f %s >%s" % (rec, out))
# if res:
#     print 'Aap exit value is %d' % res

f = open(out)
l = f.read()
ok = """dmd
dmd
yes
Aap: Error in recipe "[^"]*rectest.aap" line 8: Cannot append to a scope: m_rectest
Aap: .* in the logfile: .*AAPDIR.log
$"""
if not re.match(ok, l):
    print 'Aap returned "%s" instead of "%s"' % (l, ok)
    res = 1
f.close()

os.remove(rec)
os.remove(out)

sys.exit(res)


# vim: set sw=4 et sts=4 tw=79 fo+=l:
