# Part of the A-A-P recipe executive: Testing of command block sections

# Copyright (C) 2002-2003 Stichting NLnet Labs
# Permission to copy and use this file is specified in the file COPYING.
# If this file is missing you can find it here: http://www.a-a-p.org/COPYING

#
# This test checks that the following works properly:
# - A command block with sections executed when building is done.
# - A command block with sections executed when building is not done.
#

import sys, os, re, glob, shutil

def runaap(args):
    return os.system("%s ..%sMain.py %s" % (sys.argv[1], os.sep, args))

os.chdir("rectest")

# Create a recipe, run it and check the output.
rec = "rectest.aap"
out = "rectest.out"
inp = "rectest.in"
outp1 = "rectest.copy"
outp2 = "rectestcopy"

def cleanup():
    for file in [ rec, out, inp, outp1, outp2 ]:
	try:
	    os.remove(file)
	except:
	    pass
    try:
	for dir in glob.glob('build-*'):
	    shutil.rmtree(dir)
    except:
	pass

cleanup()

# Create the recipe.
f = open(rec, "w")
f.write("""
:rule %%.copy : %%.in
   # comment
   >always
# comment
      :print always done
   >build
      :copy $source $target
      :print build done
   >nobuild    # comment
      :print nobuild done
   >always
      :print always again
   >build
      :print build again
all: %s %s
    :print PASS
%s : %s
        >build
          :copy $source $target
        >always
             :print always in depend
        >nobuild
            :print nobuild in depend
""" % (outp1, outp2, outp2, inp))
f.close()

# Create the source file.
f = open(inp, "w")
f.write("""
int foo() {return 0;}
""")
f.close()


# Run it, the "build" sections will be executed.

res1 = runaap("-f %s >%s" % (rec, out))

f = open(out)
actual = f.read()
f.close()
expected = """always done
Aap: Copied "%s" to "%s"
build done
always again
build again
Aap: Copied "%s" to "%s"
always in depend
PASS
""" % (inp, outp1, inp, outp2)
if actual != expected:
    print 'Aap failed to behave as expected - output was:'
    print actual
    print 'Instead of:'
    print expected
    res1 = 1

# Run it again, now the "nobuild" sections will be executed.
res2 = runaap("-f %s >%s" % (rec, out))

f = open(out)
actual = f.read()
f.close()
expected = """always done
nobuild done
always again
always in depend
nobuild in depend
PASS
"""
if actual != expected:
    print 'Aap failed to behave as expected - output was:'
    print actual
    print 'Instead of:'
    print expected
    resw = 1

cleanup()
sys.exit(res1 + res2)

# vim: set sw=4 et sts=4 tw=79 fo+=l:
