# [devil.android.device_utils](https://github.com/catapult-project/catapult/blob/master/devil/devil/android/device_utils.py)

*This page was autogenerated by `devil/utils/markdown.py --module-link https://github.com/catapult-project/catapult/blob/master/devil/devil/android/device_utils.py`*

## DeviceUtils

### DeviceUtils.\_\_init\_\_

DeviceUtils constructor.
```
    Args:
      device: Either a device serial, an existing AdbWrapper instance, or an
        an existing AndroidCommands instance.
      enable_device_files_cache: For PushChangedFiles(), cache checksums of
        pushed files rather than recomputing them on a subsequent call.
      default_timeout: An integer containing the default number of seconds to
        wait for an operation to complete if no explicit value is provided.
      default_retries: An integer containing the default number or times an
        operation should be retried on failure if no explicit value is provided.
```


### DeviceUtils.\_\_eq\_\_

Checks whether |other| refers to the same device as |self|.
```
    Args:
      other: The object to compare to. This can be a basestring, an instance
        of adb_wrapper.AdbWrapper, or an instance of DeviceUtils.
    Returns:
      Whether |other| refers to the same device as |self|.
```


### DeviceUtils.\_\_lt\_\_

Compares two instances of DeviceUtils.
```
    This merely compares their serial numbers.

    Args:
      other: The instance of DeviceUtils to compare to.
    Returns:
      Whether |self| is less than |other|.
```


### DeviceUtils.\_\_str\_\_

Returns the device serial.
### DeviceUtils.NeedsSU

Checks whether 'su' is needed to access protected resources.
```
    Args:
      timeout: timeout in seconds
      retries: number of retries

    Returns:
      True if 'su' is available on the device and is needed to to access
        protected resources; False otherwise if either 'su' is not available
        (e.g. because the device has a user build), or not needed (because adbd
        already has root privileges).

    Raises:
      CommandTimeoutError on timeout.
      DeviceUnreachableError on missing device.
```


### DeviceUtils.IsOnline

Checks whether the device is online.
```
    Args:
      timeout: timeout in seconds
      retries: number of retries

    Returns:
      True if the device is online, False otherwise.

    Raises:
      CommandTimeoutError on timeout.
```


### DeviceUtils.HasRoot

Checks whether or not adbd has root privileges.
```
    Args:
      timeout: timeout in seconds
      retries: number of retries

    Returns:
      True if adbd has root privileges, False otherwise.

    Raises:
      CommandTimeoutError on timeout.
      DeviceUnreachableError on missing device.
```


### DeviceUtils.EnableRoot

Restarts adbd with root privileges.
```
    Args:
      timeout: timeout in seconds
      retries: number of retries

    Raises:
      CommandFailedError if root could not be enabled.
      CommandTimeoutError on timeout.
```


### DeviceUtils.IsUserBuild

Checks whether or not the device is running a user build.
```
    Args:
      timeout: timeout in seconds
      retries: number of retries

    Returns:
      True if the device is running a user build, False otherwise (i.e. if
        it's running a userdebug build).

    Raises:
      CommandTimeoutError on timeout.
      DeviceUnreachableError on missing device.
```


### DeviceUtils.GetExternalStoragePath

Get the device's path to its SD card.
```
    Args:
      timeout: timeout in seconds
      retries: number of retries

    Returns:
      The device's path to its SD card.

    Raises:
      CommandFailedError if the external storage path could not be determined.
      CommandTimeoutError on timeout.
      DeviceUnreachableError on missing device.
```


### DeviceUtils.GetIMEI

Get the device's IMEI.
```
    Args:
      timeout: timeout in seconds
      retries: number of retries

    Returns:
      The device's IMEI.

    Raises:
      AdbCommandFailedError on error
```


### DeviceUtils.GetApplicationPaths

Get the paths of the installed apks on the device for the given package.
```
    Args:
      package: Name of the package.

    Returns:
      List of paths to the apks on the device for the given package.
```


### DeviceUtils.TakeBugReport

Takes a bug report and dumps it to the specified path.
```
    This doesn't use adb's bugreport option since its behavior is dependent on
    both adb version and device OS version. To make it simpler, this directly
    runs the bugreport command on the device itself and dumps the stdout to a
    file.

    Args:
      path: Path on the host to drop the bug report.
      timeout: (optional) Timeout per try in seconds.
      retries: (optional) Number of retries to attempt.
```


### DeviceUtils.GetApplicationVersion

Get the version name of a package installed on the device.
```
    Args:
      package: Name of the package.

    Returns:
      A string with the version name or None if the package is not found
      on the device.
```


### DeviceUtils.GetApplicationDataDirectory

Get the data directory on the device for the given package.
```
    Args:
      package: Name of the package.

    Returns:
      The package's data directory.
    Raises:
      CommandFailedError if the package's data directory can't be found,
        whether because it's not installed or otherwise.
```


### DeviceUtils.WaitUntilFullyBooted

Wait for the device to fully boot.
```
    This means waiting for the device to boot, the package manager to be
    available, and the SD card to be ready. It can optionally mean waiting
    for wifi to come up, too.

    Args:
      wifi: A boolean indicating if we should wait for wifi to come up or not.
      timeout: timeout in seconds
      retries: number of retries

    Raises:
      CommandFailedError on failure.
      CommandTimeoutError if one of the component waits times out.
      DeviceUnreachableError if the device becomes unresponsive.
```


### DeviceUtils.Reboot

Reboot the device.
```
    Args:
      block: A boolean indicating if we should wait for the reboot to complete.
      wifi: A boolean indicating if we should wait for wifi to be enabled after
        the reboot. The option has no effect unless |block| is also True.
      timeout: timeout in seconds
      retries: number of retries

    Raises:
      CommandTimeoutError on timeout.
      DeviceUnreachableError on missing device.
```


### DeviceUtils.Install

Install an APK.
```
    Noop if an identical APK is already installed.

    Args:
      apk: An ApkHelper instance or string containing the path to the APK.
      allow_downgrade: A boolean indicating if we should allow downgrades.
      reinstall: A boolean indicating if we should keep any existing app data.
      permissions: Set of permissions to set. If not set, finds permissions with
          apk helper. To set no permissions, pass [].
      timeout: timeout in seconds
      retries: number of retries

    Raises:
      CommandFailedError if the installation fails.
      CommandTimeoutError if the installation times out.
      DeviceUnreachableError on missing device.
```


### DeviceUtils.InstallSplitApk

Install a split APK.
```
    Noop if all of the APK splits are already installed.

    Args:
      base_apk: An ApkHelper instance or string containing the path to the base
          APK.
      split_apks: A list of strings of paths of all of the APK splits.
      allow_downgrade: A boolean indicating if we should allow downgrades.
      reinstall: A boolean indicating if we should keep any existing app data.
      allow_cached_props: Whether to use cached values for device properties.
      permissions: Set of permissions to set. If not set, finds permissions with
          apk helper. To set no permissions, pass [].
      timeout: timeout in seconds
      retries: number of retries

    Raises:
      CommandFailedError if the installation fails.
      CommandTimeoutError if the installation times out.
      DeviceUnreachableError on missing device.
      DeviceVersionError if device SDK is less than Android L.
```


### DeviceUtils.Uninstall

Remove the app |package\_name| from the device.
```
    This is a no-op if the app is not already installed.

    Args:
      package_name: The package to uninstall.
      keep_data: (optional) Whether to keep the data and cache directories.
      timeout: Timeout in seconds.
      retries: Number of retries.

    Raises:
      CommandFailedError if the uninstallation fails.
      CommandTimeoutError if the uninstallation times out.
      DeviceUnreachableError on missing device.
```


### DeviceUtils.RunShellCommand

Run an ADB shell command.
```
    The command to run |cmd| should be a sequence of program arguments
    (preferred) or a single string with a shell script to run.

    When |cmd| is a sequence, it is assumed to contain the name of the command
    to run followed by its arguments. In this case, arguments are passed to the
    command exactly as given, preventing any further processing by the shell.
    This allows callers to easily pass arguments with spaces or special
    characters without having to worry about quoting rules. Whenever possible,
    it is recomended to pass |cmd| as a sequence.

    When |cmd| is passed as a single string, |shell| should be set to True.
    The command will be interpreted and run by the shell on the device,
    allowing the use of shell features such as pipes, wildcards, or variables.
    Failing to set shell=True will issue a warning, but this will be changed
    to a hard failure in the future (see: catapult:#3242).

    This behaviour is consistent with that of command runners in cmd_helper as
    well as Python's own subprocess.Popen.

    TODO(perezju) Change the default of |check_return| to True when callers
      have switched to the new behaviour.

    Args:
      cmd: A sequence containing the command to run and its arguments, or a
        string with a shell script to run (should also set shell=True).
      shell: A boolean indicating whether shell features may be used in |cmd|.
      check_return: A boolean indicating whether or not the return code should
        be checked.
      cwd: The device directory in which the command should be run.
      env: The environment variables with which the command should be run.
      run_as: A string containing the package as which the command should be
        run.
      as_root: A boolean indicating whether the shell command should be run
        with root privileges.
      single_line: A boolean indicating if only a single line of output is
        expected.
      large_output: Uses a work-around for large shell command output. Without
        this large output will be truncated.
      raw_output: Whether to only return the raw output
          (no splitting into lines).
      timeout: timeout in seconds
      retries: number of retries

    Returns:
      If single_line is False, the output of the command as a list of lines,
      otherwise, a string with the unique line of output emmited by the command
      (with the optional newline at the end stripped).

    Raises:
      AdbCommandFailedError if check_return is True and the exit code of
        the command run on the device is non-zero.
      CommandFailedError if single_line is True but the output contains two or
        more lines.
      CommandTimeoutError on timeout.
      DeviceUnreachableError on missing device.
```


### DeviceUtils.KillAll

Kill all processes with the given name on the device.
```
    Args:
      process_name: A string containing the name of the process to kill.
      exact: A boolean indicating whether to kill all processes matching
             the string |process_name| exactly, or all of those which contain
             |process_name| as a substring. Defaults to False.
      signum: An integer containing the signal number to send to kill. Defaults
              to SIGKILL (9).
      as_root: A boolean indicating whether the kill should be executed with
               root privileges.
      blocking: A boolean indicating whether we should wait until all processes
                with the given |process_name| are dead.
      quiet: A boolean indicating whether to ignore the fact that no processes
             to kill were found.
      timeout: timeout in seconds
      retries: number of retries

    Returns:
      The number of processes attempted to kill.

    Raises:
      CommandFailedError if no process was killed and |quiet| is False.
      CommandTimeoutError on timeout.
      DeviceUnreachableError on missing device.
```


### DeviceUtils.StartActivity

Start package's activity on the device.
```
    Args:
      intent_obj: An Intent object to send.
      blocking: A boolean indicating whether we should wait for the activity to
                finish launching.
      trace_file_name: If present, a string that both indicates that we want to
                       profile the activity and contains the path to which the
                       trace should be saved.
      force_stop: A boolean indicating whether we should stop the activity
                  before starting it.
      timeout: timeout in seconds
      retries: number of retries

    Raises:
      CommandFailedError if the activity could not be started.
      CommandTimeoutError on timeout.
      DeviceUnreachableError on missing device.
```


### DeviceUtils.StartInstrumentation

### DeviceUtils.BroadcastIntent

Send a broadcast intent.
```
    Args:
      intent: An Intent to broadcast.
      timeout: timeout in seconds
      retries: number of retries

    Raises:
      CommandTimeoutError on timeout.
      DeviceUnreachableError on missing device.
```


### DeviceUtils.GoHome

Return to the home screen and obtain launcher focus.
```
    This command launches the home screen and attempts to obtain
    launcher focus until the timeout is reached.

    Args:
      timeout: timeout in seconds
      retries: number of retries

    Raises:
      CommandTimeoutError on timeout.
      DeviceUnreachableError on missing device.
```


### DeviceUtils.ForceStop

Close the application.
```
    Args:
      package: A string containing the name of the package to stop.
      timeout: timeout in seconds
      retries: number of retries

    Raises:
      CommandTimeoutError on timeout.
      DeviceUnreachableError on missing device.
```


### DeviceUtils.ClearApplicationState

Clear all state for the given package.
```
    Args:
      package: A string containing the name of the package to stop.
      permissions: List of permissions to set after clearing data.
      timeout: timeout in seconds
      retries: number of retries

    Raises:
      CommandTimeoutError on timeout.
      DeviceUnreachableError on missing device.
```


### DeviceUtils.SendKeyEvent

Sends a keycode to the device.
```
    See the devil.android.sdk.keyevent module for suitable keycode values.

    Args:
      keycode: A integer keycode to send to the device.
      timeout: timeout in seconds
      retries: number of retries

    Raises:
      CommandTimeoutError on timeout.
      DeviceUnreachableError on missing device.
```


### DeviceUtils.PushChangedFiles

Push files to the device, skipping files that don't need updating.
```
    When a directory is pushed, it is traversed recursively on the host and
    all files in it are pushed to the device as needed.
    Additionally, if delete_device_stale option is True,
    files that exist on the device but don't exist on the host are deleted.

    Args:
      host_device_tuples: A list of (host_path, device_path) tuples, where
        |host_path| is an absolute path of a file or directory on the host
        that should be minimially pushed to the device, and |device_path| is
        an absolute path of the destination on the device.
      timeout: timeout in seconds
      retries: number of retries
      delete_device_stale: option to delete stale files on device

    Raises:
      CommandFailedError on failure.
      CommandTimeoutError on timeout.
      DeviceUnreachableError on missing device.
```


### DeviceUtils.FileExists

Checks whether the given file exists on the device.
```
    Arguments are the same as PathExists.
```


### DeviceUtils.PathExists

Checks whether the given path(s) exists on the device.
```
    Args:
      device_path: A string containing the absolute path to the file on the
                   device, or an iterable of paths to check.
      as_root: Whether root permissions should be use to check for the existence
               of the given path(s).
      timeout: timeout in seconds
      retries: number of retries

    Returns:
      True if the all given paths exist on the device, False otherwise.

    Raises:
      CommandTimeoutError on timeout.
      DeviceUnreachableError on missing device.
```


### DeviceUtils.RemovePath

Removes the given path(s) from the device.
```
    Args:
      device_path: A string containing the absolute path to the file on the
                   device, or an iterable of paths to check.
      force: Whether to remove the path(s) with force (-f).
      recursive: Whether to remove any directories in the path(s) recursively.
      as_root: Whether root permissions should be use to remove the given
               path(s).
      rename: Whether to rename the path(s) before removing to help avoid
            filesystem errors. See https://stackoverflow.com/questions/11539657
      timeout: timeout in seconds
      retries: number of retries
```


### DeviceUtils.PullFile

Pull a file from the device.
```
    Args:
      device_path: A string containing the absolute path of the file to pull
                   from the device.
      host_path: A string containing the absolute path of the destination on
                 the host.
      timeout: timeout in seconds
      retries: number of retries

    Raises:
      CommandFailedError on failure.
      CommandTimeoutError on timeout.
```


### DeviceUtils.ReadFile

Reads the contents of a file from the device.
```
    Args:
      device_path: A string containing the absolute path of the file to read
                   from the device.
      as_root: A boolean indicating whether the read should be executed with
               root privileges.
      force_pull: A boolean indicating whether to force the operation to be
          performed by pulling a file from the device. The default is, when the
          contents are short, to retrieve the contents using cat instead.
      timeout: timeout in seconds
      retries: number of retries

    Returns:
      The contents of |device_path| as a string. Contents are intepreted using
      universal newlines, so the caller will see them encoded as '
'. Also,
      all lines will be terminated.

    Raises:
      AdbCommandFailedError if the file can't be read.
      CommandTimeoutError on timeout.
      DeviceUnreachableError on missing device.
```


### DeviceUtils.WriteFile

Writes |contents| to a file on the device.
```
    Args:
      device_path: A string containing the absolute path to the file to write
          on the device.
      contents: A string containing the data to write to the device.
      as_root: A boolean indicating whether the write should be executed with
          root privileges (if available).
      force_push: A boolean indicating whether to force the operation to be
          performed by pushing a file to the device. The default is, when the
          contents are short, to pass the contents using a shell script instead.
      timeout: timeout in seconds
      retries: number of retries

    Raises:
      CommandFailedError if the file could not be written on the device.
      CommandTimeoutError on timeout.
      DeviceUnreachableError on missing device.
```


### DeviceUtils.ListDirectory

List all files on a device directory.
```
    Mirroring os.listdir (and most client expectations) the resulting list
    does not include the special entries '.' and '..' even if they are present
    in the directory.

    Args:
      device_path: A string containing the path of the directory on the device
                   to list.
      as_root: A boolean indicating whether the to use root privileges to list
               the directory contents.
      timeout: timeout in seconds
      retries: number of retries

    Returns:
      A list of filenames for all entries contained in the directory.

    Raises:
      AdbCommandFailedError if |device_path| does not specify a valid and
          accessible directory in the device.
      CommandTimeoutError on timeout.
      DeviceUnreachableError on missing device.
```


### DeviceUtils.StatDirectory

List file and stat info for all entries on a device directory.
```
    Implementation notes: this is currently implemented by parsing the output
    of 'ls -a -l' on the device. Whether possible and convenient, we attempt to
    make parsing strict and return values mirroring those of the standard |os|
    and |stat| Python modules.

    Mirroring os.listdir (and most client expectations) the resulting list
    does not include the special entries '.' and '..' even if they are present
    in the directory.

    Args:
      device_path: A string containing the path of the directory on the device
                   to list.
      as_root: A boolean indicating whether the to use root privileges to list
               the directory contents.
      timeout: timeout in seconds
      retries: number of retries

    Returns:
      A list of dictionaries, each containing the following keys:
        filename: A string with the file name.
        st_mode: File permissions, use the stat module to interpret these.
        st_nlink: Number of hard links (may be missing).
        st_owner: A string with the user name of the owner.
        st_group: A string with the group name of the owner.
        st_rdev_pair: Device type as (major, minior) (only if inode device).
        st_size: Size of file, in bytes (may be missing for non-regular files).
        st_mtime: Time of most recent modification, in seconds since epoch
          (although resolution is in minutes).
        symbolic_link_to: If entry is a symbolic link, path where it points to;
          missing otherwise.

    Raises:
      AdbCommandFailedError if |device_path| does not specify a valid and
          accessible directory in the device.
      CommandTimeoutError on timeout.
      DeviceUnreachableError on missing device.
```


### DeviceUtils.StatPath

Get the stat attributes of a file or directory on the device.
```
    Args:
      device_path: A string containing the path of a file or directory from
                   which to get attributes.
      as_root: A boolean indicating whether the to use root privileges to
               access the file information.
      timeout: timeout in seconds
      retries: number of retries

    Returns:
      A dictionary with the stat info collected; see StatDirectory for details.

    Raises:
      CommandFailedError if device_path cannot be found on the device.
      CommandTimeoutError on timeout.
      DeviceUnreachableError on missing device.
```


### DeviceUtils.FileSize

Get the size of a file on the device.
```
    Note: This is implemented by parsing the output of the 'ls' command on
    the device. On some Android versions, when passing a directory or special
    file, the size is *not* reported and this function will throw an exception.

    Args:
      device_path: A string containing the path of a file on the device.
      as_root: A boolean indicating whether the to use root privileges to
               access the file information.
      timeout: timeout in seconds
      retries: number of retries

    Returns:
      The size of the file in bytes.

    Raises:
      CommandFailedError if device_path cannot be found on the device, or
        its size cannot be determited for some reason.
      CommandTimeoutError on timeout.
      DeviceUnreachableError on missing device.
```


### DeviceUtils.GetLanguage

Returns the language setting on the device.
```
    Args:
      cache: Whether to use cached properties when available.
```


### DeviceUtils.SetJavaAsserts

Enables or disables Java asserts.
```
    Args:
      enabled: A boolean indicating whether Java asserts should be enabled
               or disabled.
      timeout: timeout in seconds
      retries: number of retries

    Returns:
      True if the device-side property changed and a restart is required as a
      result, False otherwise.

    Raises:
      CommandTimeoutError on timeout.
```


### DeviceUtils.GetCountry

Returns the country setting on the device.
```
    Args:
      cache: Whether to use cached properties when available.
```


### DeviceUtils.GetApplicationPids

Returns the PID or PIDs of a given process name.
```
    Note that the |process_name|, often the package name, must match exactly.

    Args:
      process_name: A string containing the process name to get the PIDs for.
      at_most_one: A boolean indicating that at most one PID is expected to
                   be found.
      timeout: timeout in seconds
      retries: number of retries

    Returns:
      A list of the PIDs for the named process. If at_most_one=True returns
      the single PID found or None otherwise.

    Raises:
      CommandFailedError if at_most_one=True and more than one PID is found
          for the named process.
      CommandTimeoutError on timeout.
      DeviceUnreachableError on missing device.
```


### DeviceUtils.GetProp

Gets a property from the device.
```
    Args:
      property_name: A string containing the name of the property to get from
                     the device.
      cache: Whether to use cached properties when available.
      timeout: timeout in seconds
      retries: number of retries

    Returns:
      The value of the device's |property_name| property.

    Raises:
      CommandTimeoutError on timeout.
```


### DeviceUtils.SetProp

Sets a property on the device.
```
    Args:
      property_name: A string containing the name of the property to set on
                     the device.
      value: A string containing the value to set to the property on the
             device.
      check: A boolean indicating whether to check that the property was
             successfully set on the device.
      timeout: timeout in seconds
      retries: number of retries

    Raises:
      CommandFailedError if check is true and the property was not correctly
        set on the device (e.g. because it is not rooted).
      CommandTimeoutError on timeout.
```


### DeviceUtils.GetABI

Gets the device main ABI.
```
    Args:
      timeout: timeout in seconds
      retries: number of retries

    Returns:
      The device's main ABI name.

    Raises:
      CommandTimeoutError on timeout.
```


### DeviceUtils.GetPids

Returns the PIDs of processes containing the given name as substring.
```
    Note that the |process_name| is often the package name.

    Args:
      process_name: A string containing the process name to get the PIDs for.
                    If missing returns PIDs for all processes.
      timeout: timeout in seconds
      retries: number of retries

    Returns:
      A dict mapping process name to a list of PIDs for each process that
      contained the provided |process_name|.

    Raises:
      CommandTimeoutError on timeout.
      DeviceUnreachableError on missing device.
```


### DeviceUtils.GetLogcatMonitor

Returns a new LogcatMonitor associated with this device.
```
    Parameters passed to this function are passed directly to
    |logcat_monitor.LogcatMonitor| and are documented there.
```


### DeviceUtils.GetEnforce

Get the current mode of SELinux.
```
    Args:
      timeout: timeout in seconds
      retries: number of retries

    Returns:
      True (enforcing), False (permissive), or None (disabled).

    Raises:
      CommandFailedError on failure.
      CommandTimeoutError on timeout.
      DeviceUnreachableError on missing device.
```


### DeviceUtils.SetEnforce

Modify the mode SELinux is running in.
```
    Args:
      enabled: a boolean indicating whether to put SELinux in encorcing mode
               (if True), or permissive mode (otherwise).
      timeout: timeout in seconds
      retries: number of retries

    Raises:
      CommandFailedError on failure.
      CommandTimeoutError on timeout.
      DeviceUnreachableError on missing device.
```


### DeviceUtils.TakeScreenshot

Takes a screenshot of the device.
```
    Args:
      host_path: A string containing the path on the host to save the
                 screenshot to. If None, a file name in the current
                 directory will be generated.
      timeout: timeout in seconds
      retries: number of retries

    Returns:
      The name of the file on the host to which the screenshot was saved.

    Raises:
      CommandFailedError on failure.
      CommandTimeoutError on timeout.
      DeviceUnreachableError on missing device.
```


### DeviceUtils.DismissCrashDialogIfNeeded

Dismiss the error/ANR dialog if present.
```
    Returns: Name of the crashed package if a dialog is focused,
             None otherwise.
```


### DeviceUtils.GetClientCache

Returns client cache.
### DeviceUtils.LoadCacheData

Initializes the cache from data created using DumpCacheData.
```
    The cache is used only if its token matches the one found on the device.
    This prevents a stale cache from being used (which can happen when sharing
    devices).

    Args:
      data: A previously serialized cache (string).
      timeout: timeout in seconds
      retries: number of retries

    Returns:
      Whether the cache was loaded.
```


### DeviceUtils.DumpCacheData

Dumps the current cache state to a string.
```
    Args:
      timeout: timeout in seconds
      retries: number of retries

    Returns:
      A serialized cache as a string.
```


### DeviceUtils.RestartAdbd

### DeviceUtils.GrantPermissions

### DeviceUtils.IsScreenOn

Determines if screen is on.
```
    Dumpsys input_method exposes screen on/off state. Below is an explination of
    the states.

    Pre-L:
      On: mScreenOn=true
      Off: mScreenOn=false
    L+:
      On: mInteractive=true
      Off: mInteractive=false

    Returns:
      True if screen is on, false if it is off.

    Raises:
      device_errors.CommandFailedError: If screen state cannot be found.
```


### DeviceUtils.SetScreen

Turns screen on and off.
```
    Args:
      on: bool to decide state to switch to. True = on False = off.
```


### GetAVDs

Returns a list of Android Virtual Devices.
```
  Returns:
    A list containing the configured AVDs.
```


### RestartServer

Restarts the adb server.
```
  Raises:
    CommandFailedError if we fail to kill or restart the server.
```


