/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.functions.string;

import com.google.clearsilver.jsilver.functions.NonEscapingFunction;
import com.google.clearsilver.jsilver.values.Value;

public class SliceFunction
extends NonEscapingFunction {
    public Value execute(Value ... args) {
        Value stringValue = args[0];
        Value startValue = args[1];
        Value endValue = args[2];
        String string = stringValue.asString();
        int start = startValue.asNumber();
        int end = endValue.asNumber();
        int length = string.length();
        if (start < 0) {
            start += Math.max(-start, length);
            if (end == 0) {
                end = length;
            }
        }
        if (end < 0) {
            end += length;
        }
        if ((end = Math.min(end, length)) < start) {
            return Value.literalConstant("", args[0]);
        }
        return Value.literalValue(string.substring(start, end), stringValue.getEscapeMode(), stringValue.isPartiallyEscaped() || startValue.isPartiallyEscaped() || endValue.isPartiallyEscaped());
    }
}

