/*
 * Decompiled with CFR 0.152.
 */
package com.android.ant;

import com.android.ant.SingleInputOutputTask;
import com.android.ant.TaskHelper;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.ExecTask;
import org.apache.tools.ant.types.Path;

public class ZipAlignTask
extends SingleInputOutputTask {
    private String mExecutable;
    private int mAlign = 4;
    private boolean mVerbose = false;

    public void setExecutable(Path executable) {
        this.mExecutable = TaskHelper.checkSinglePath("executable", executable);
    }

    public void setAlign(int align) {
        this.mAlign = align;
    }

    public void setVerbose(boolean verbose) {
        this.mVerbose = verbose;
    }

    @Override
    public void createOutput() throws BuildException {
        if (this.mExecutable == null) {
            throw new BuildException("Missing attribute executable");
        }
        System.out.println("Running zip align on final apk...");
        this.doZipAlign();
    }

    private void doZipAlign() {
        ExecTask task = new ExecTask();
        task.setExecutable(this.mExecutable);
        task.setFailonerror(true);
        task.setProject(this.getProject());
        task.setOwningTarget(this.getOwningTarget());
        task.setTaskName("zip-align");
        task.createArg().setValue("-f");
        if (this.mVerbose) {
            task.createArg().setValue("-v");
        }
        task.createArg().setValue(Integer.toString(this.mAlign));
        task.createArg().setValue(this.getInput());
        task.createArg().setValue(this.getOutput());
        task.execute();
    }
}

