/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmuilib.explorer;

import com.android.ddmlib.FileListingService;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;

class DeviceContentProvider
implements ITreeContentProvider {
    private TreeViewer mViewer;
    private FileListingService mFileListingService;
    private FileListingService.FileEntry mRootEntry;
    private FileListingService.IListingReceiver sListingReceiver = new FileListingService.IListingReceiver(){

        @Override
        public void setChildren(final FileListingService.FileEntry entry, FileListingService.FileEntry[] children) {
            Display display;
            final Tree t = DeviceContentProvider.this.mViewer.getTree();
            if (t != null && !t.isDisposed() && !(display = t.getDisplay()).isDisposed()) {
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!t.isDisposed()) {
                            DeviceContentProvider.this.mViewer.refresh(entry);
                            DeviceContentProvider.this.mViewer.setExpandedState(entry, true);
                        }
                    }
                });
            }
        }

        @Override
        public void refreshEntry(final FileListingService.FileEntry entry) {
            Display display;
            final Tree t = DeviceContentProvider.this.mViewer.getTree();
            if (t != null && !t.isDisposed() && !(display = t.getDisplay()).isDisposed()) {
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!t.isDisposed()) {
                            DeviceContentProvider.this.mViewer.refresh(entry);
                        }
                    }
                });
            }
        }
    };

    public void setListingService(FileListingService fls) {
        this.mFileListingService = fls;
    }

    @Override
    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof FileListingService.FileEntry) {
            FileListingService.FileEntry parentEntry = (FileListingService.FileEntry)parentElement;
            Object[] oldEntries = parentEntry.getCachedChildren();
            Object[] newEntries = this.mFileListingService.getChildren(parentEntry, true, this.sListingReceiver);
            if (newEntries != null) {
                return newEntries;
            }
            return oldEntries;
        }
        return new Object[0];
    }

    @Override
    public Object getParent(Object element) {
        if (element instanceof FileListingService.FileEntry) {
            FileListingService.FileEntry entry = (FileListingService.FileEntry)element;
            return entry.getParent();
        }
        return null;
    }

    @Override
    public boolean hasChildren(Object element) {
        if (element instanceof FileListingService.FileEntry) {
            FileListingService.FileEntry entry = (FileListingService.FileEntry)element;
            return entry.getType() == 1;
        }
        return false;
    }

    @Override
    public Object[] getElements(Object inputElement) {
        FileListingService.FileEntry entry;
        if (inputElement instanceof FileListingService.FileEntry && (entry = (FileListingService.FileEntry)inputElement).isRoot()) {
            return this.getChildren(this.mRootEntry);
        }
        return null;
    }

    @Override
    public void dispose() {
    }

    @Override
    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (viewer instanceof TreeViewer) {
            this.mViewer = (TreeViewer)viewer;
        }
        if (newInput instanceof FileListingService.FileEntry) {
            this.mRootEntry = (FileListingService.FileEntry)newInput;
        }
    }
}

