/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma.instr;

import com.vladium.emma.EMMARuntimeException;
import com.vladium.emma.Processor;
import com.vladium.emma.filter.IInclExclFilter;
import com.vladium.emma.instr.InstrProcessorST;
import com.vladium.util.Files;
import com.vladium.util.IConstants;
import com.vladium.util.IPathEnumerator;
import java.io.File;

public abstract class InstrProcessor
extends Processor
implements IPathEnumerator.IPathHandler {
    public static final String PROPERTY_EXCLUDE_SYNTHETIC_METHODS = "instr.exclude_synthetic_methods";
    public static final String PROPERTY_EXCLUDE_BRIDGE_METHODS = "instr.exclude_bridge_methods";
    public static final String PROPERTY_DO_SUID_COMPENSATION = "instr.do_suid_compensation";
    public static final String DEFAULT_EXCLUDE_SYNTHETIC_METHODS = "true";
    public static final String DEFAULT_EXCLUDE_BRIDGE_METHODS = "true";
    public static final String DEFAULT_DO_SUID_COMPENSATION = "true";
    protected File[] m_instrPath;
    protected boolean m_dependsMode = true;
    protected boolean m_canonical;
    protected IInclExclFilter m_coverageFilter;
    protected OutMode m_outMode;
    protected File m_outDir;
    protected File m_mdataOutFile;
    protected Boolean m_mdataOutMerge;
    protected int m_classCopies;
    protected int m_classInstrs;
    protected static final String CLASSES = "classes";
    protected static final String LIB = "lib";
    protected static final boolean IN_CLASSES = true;
    protected static final boolean IN_LIB = false;

    public static InstrProcessor create() {
        return new InstrProcessorST();
    }

    public final synchronized void setInstrPath(String[] stringArray, boolean bl) {
        this.m_instrPath = stringArray == null || stringArray.length == 0 ? IConstants.EMPTY_FILE_ARRAY : Files.pathToFiles(stringArray, bl);
        this.m_canonical = bl;
    }

    public final synchronized void setDependsMode(boolean bl) {
        this.m_dependsMode = bl;
    }

    public final synchronized void setInclExclFilter(String[] stringArray) {
        this.m_coverageFilter = stringArray == null ? null : IInclExclFilter.Factory.create(stringArray);
    }

    public final synchronized void setMetaOutFile(String string) {
        if (string == null) {
            this.m_mdataOutFile = null;
        } else {
            File file = new File(string);
            if (file.exists() && !file.isFile()) {
                throw new IllegalArgumentException("not a file: [" + file.getAbsolutePath() + "]");
            }
            this.m_mdataOutFile = file;
        }
    }

    public final synchronized void setMetaOutMerge(Boolean bl) {
        this.m_mdataOutMerge = bl;
    }

    public final synchronized void setInstrOutDir(String string) {
        if (string == null) {
            this.m_outDir = null;
        } else {
            File file = new File(string);
            if (file.exists() && !file.isDirectory()) {
                throw new IllegalArgumentException("not a directory: [" + file.getAbsolutePath() + "]");
            }
            this.m_outDir = file;
        }
    }

    public final synchronized void setOutMode(OutMode outMode) {
        if (outMode == null) {
            throw new IllegalArgumentException("null input: mode");
        }
        this.m_outMode = outMode;
    }

    protected InstrProcessor() {
    }

    protected void validateState() {
        super.validateState();
        if (this.m_instrPath == null || this.m_instrPath.length == 0) {
            throw new IllegalStateException("instrumentation path not set");
        }
        if (this.m_outMode == null) {
            throw new IllegalStateException("output mode not set");
        }
        if (this.m_outMode != OutMode.OUT_MODE_OVERWRITE) {
            int n;
            File[] fileArray;
            if (this.m_outDir == null) {
                throw new IllegalStateException("output directory not set");
            }
            File file = Files.canonicalizeFile(this.m_outDir);
            if (this.m_canonical) {
                fileArray = this.m_instrPath;
            } else {
                fileArray = new File[this.m_instrPath.length];
                for (n = 0; n < fileArray.length; ++n) {
                    fileArray[n] = Files.canonicalizeFile(this.m_instrPath[n]);
                }
            }
            n = fileArray.length;
            for (File file2 = file; file2 != null; file2 = file2.getParentFile()) {
                for (int i = 0; i < n; ++i) {
                    if (!file2.equals(fileArray[i])) continue;
                    throw new IllegalStateException("output directory [" + file + "] cannot be one of the instrumentation path directories (or a child thereof)");
                }
            }
        }
    }

    protected void reset() {
        this.m_classInstrs = 0;
        this.m_classCopies = 0;
    }

    protected final void createDir(File file, boolean bl) throws EMMARuntimeException {
        if (bl ? !file.mkdirs() && !file.exists() : !file.mkdir() && !file.exists()) {
            throw new EMMARuntimeException("OUT_MKDIR_FAILURE", new Object[]{file.getAbsolutePath()});
        }
    }

    protected final File getFullOutDir(File file, boolean bl) {
        if (this.m_outMode == OutMode.OUT_MODE_OVERWRITE) {
            return file;
        }
        if (this.m_outMode == OutMode.OUT_MODE_COPY) {
            return this.m_outDir;
        }
        if (this.m_outMode == OutMode.OUT_MODE_FULLCOPY) {
            return bl ? Files.newFile(this.m_outDir, CLASSES) : Files.newFile(this.m_outDir, LIB);
        }
        throw new IllegalStateException("invalid out mode state: " + this.m_outMode);
    }

    protected final File getFullOutFile(File file, File file2, boolean bl) {
        return Files.newFile(this.getFullOutDir(file, bl), file2.getPath());
    }

    public static final class OutMode {
        public static final OutMode OUT_MODE_COPY = new OutMode("copy");
        public static final OutMode OUT_MODE_FULLCOPY = new OutMode("fullcopy");
        public static final OutMode OUT_MODE_OVERWRITE = new OutMode("overwrite");
        private final String m_name;

        public String getName() {
            return this.m_name;
        }

        public String toString() {
            return this.m_name;
        }

        public static OutMode nameToMode(String string) {
            if (OutMode.OUT_MODE_COPY.m_name.equals(string)) {
                return OUT_MODE_COPY;
            }
            if (OutMode.OUT_MODE_FULLCOPY.m_name.equals(string)) {
                return OUT_MODE_FULLCOPY;
            }
            if (OutMode.OUT_MODE_OVERWRITE.m_name.equals(string)) {
                return OUT_MODE_OVERWRITE;
            }
            return null;
        }

        private OutMode(String string) {
            this.m_name = string;
        }
    }
}

