/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma.report;

import com.vladium.emma.data.MethodDescriptor;
import com.vladium.emma.report.ClassItem;
import com.vladium.emma.report.IItem;
import com.vladium.emma.report.IItemMetadata;
import com.vladium.emma.report.IItemVisitor;
import com.vladium.emma.report.Item;
import com.vladium.util.Descriptors;
import com.vladium.util.IntObjectMap;

public final class MethodItem
extends Item {
    private final int m_ID;
    private final String m_name;
    private final String m_descriptor;
    private final int m_firstLine;
    private transient String m_userName;
    private static final Item.ItemMetadata METADATA = new Item.ItemMetadata(4, "method", 29L);

    public MethodItem(IItem iItem, int n, String string, String string2, int n2) {
        super(iItem);
        this.m_ID = n;
        this.m_name = string;
        this.m_descriptor = string2;
        this.m_firstLine = n2;
    }

    public String getName() {
        if (this.m_userName == null) {
            this.m_userName = Descriptors.methodVMNameToJavaName(this.m_parent.getName(), this.m_name, this.m_descriptor, true, true, true);
        }
        return this.m_userName;
    }

    public int getID() {
        return this.m_ID;
    }

    public int getFirstLine() {
        return this.m_firstLine;
    }

    public int getAggregate(int n) {
        int[] nArray = this.m_aggregates;
        int n2 = nArray[n];
        if (n2 < 0) {
            ClassItem classItem = (ClassItem)this.m_parent;
            MethodDescriptor methodDescriptor = classItem.m_cls.getMethods()[this.m_ID];
            int n3 = methodDescriptor.getStatus();
            if ((n3 & 0xE) != 0) {
                for (int i = 0; i < nArray.length; ++i) {
                    nArray[i] = 0;
                }
            } else {
                boolean bl = (n3 & 1) == 0;
                boolean[] blArray = classItem.m_coverage != null ? classItem.m_coverage[this.m_ID] : null;
                int n4 = methodDescriptor.getBlockCount();
                nArray[10] = 1;
                nArray[6] = n4;
                int n5 = 0;
                int[] nArray2 = methodDescriptor.getBlockSizes();
                if (blArray != null) {
                    int n6;
                    int n7 = 0;
                    int n8 = 0;
                    int n9 = 0;
                    int n10 = 0;
                    for (int i = 0; i < n4; ++i) {
                        n6 = nArray2[i];
                        n5 += n6;
                        if (!blArray[i]) continue;
                        ++n7;
                        n9 += n6;
                    }
                    if (bl) {
                        IntObjectMap intObjectMap = methodDescriptor.getLineMap();
                        nArray[7] = n6 = intObjectMap.size();
                        int[] nArray3 = intObjectMap.keys();
                        for (int i = 0; i < n6; ++i) {
                            int[] nArray4 = (int[])intObjectMap.get(nArray3[i]);
                            int n11 = 0;
                            int n12 = nArray4.length;
                            int n13 = 0;
                            int n14 = 0;
                            for (int j = 0; j < n12; ++j) {
                                int n15 = nArray4[j];
                                int n16 = nArray2[n15];
                                n14 += n16;
                                if (!blArray[n15]) continue;
                                ++n11;
                                n13 += n16;
                            }
                            n8 += 100 * n11 / n12;
                            n10 += 100 * n13 / n14;
                        }
                        nArray[1] = n8;
                        nArray[3] = n10;
                    }
                    nArray[8] = n5;
                    nArray[4] = n7 > 0 ? 1 : 0;
                    nArray[0] = n7;
                    nArray[2] = n9;
                } else {
                    for (int i = 0; i < n4; ++i) {
                        n5 += nArray2[i];
                    }
                    nArray[8] = n5;
                    nArray[4] = 0;
                    nArray[0] = 0;
                    nArray[2] = 0;
                    if (bl) {
                        int n17;
                        IntObjectMap intObjectMap = methodDescriptor.getLineMap();
                        nArray[7] = n17 = intObjectMap.size();
                        nArray[1] = 0;
                        nArray[3] = 0;
                    }
                }
            }
            return nArray[n];
        }
        return n2;
    }

    public void accept(IItemVisitor iItemVisitor, Object object) {
        iItemVisitor.visit(this, object);
    }

    public final IItemMetadata getMetadata() {
        return METADATA;
    }

    public static IItemMetadata getTypeMetadata() {
        return METADATA;
    }
}

