/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma;

import com.vladium.emma.Command;
import com.vladium.emma.EMMARuntimeException;
import com.vladium.emma.Processor;
import com.vladium.emma.rt.AppRunner;
import com.vladium.util.ClassLoaderResolver;
import com.vladium.util.Strings;
import com.vladium.util.args.IOptsParser;
import java.io.File;
import java.io.IOException;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public final class runCommand
extends Command {
    private String[] m_classpath;
    private String[] m_srcpath;
    private boolean m_jarMode;
    private boolean m_scanCoveragePath;
    private String[] m_ixpath;
    private String[] m_appArgs;
    private boolean m_dumpRawData;
    private String m_outFileName;
    private Boolean m_outDataMerge;
    private String[] m_reportTypes;
    private static final boolean DEFAULT_TO_SYSTEM_CLASSPATH = false;

    public synchronized void run() {
        ClassLoader classLoader;
        try {
            classLoader = ClassLoaderResolver.getClassLoader();
        }
        catch (Throwable throwable) {
            classLoader = this.getClass().getClassLoader();
        }
        try {
            String string;
            Object object;
            String[] stringArray = this.getOptParser(classLoader);
            Object object2 = stringArray.parse(this.m_args);
            int n = object2.usageRequestLevel();
            if (n > 0) {
                this.usageexit((IOptsParser)stringArray, n, null);
                return;
            }
            IOptsParser.IOpt[] iOptArray = object2.getOpts();
            if (iOptArray == null) {
                object2.error(this.m_out, 80);
                this.usageexit((IOptsParser)stringArray, 1, null);
                return;
            }
            try {
                for (int i = 0; i < iOptArray.length; ++i) {
                    object = iOptArray[i];
                    string = object.getCanonicalName();
                    if (this.processOpt((IOptsParser.IOpt)object)) continue;
                    if ("cp".equals(string)) {
                        this.m_classpath = runCommand.getListOptValue((IOptsParser.IOpt)object, PATH_DELIMITERS, true);
                        continue;
                    }
                    if ("jar".equals(string)) {
                        this.m_jarMode = true;
                        continue;
                    }
                    if ("f".equals(string)) {
                        this.m_scanCoveragePath = runCommand.getOptionalBooleanOptValue((IOptsParser.IOpt)object);
                        continue;
                    }
                    if ("sp".equals(string)) {
                        this.m_srcpath = runCommand.getListOptValue((IOptsParser.IOpt)object, PATH_DELIMITERS, true);
                        continue;
                    }
                    if ("raw".equals(string)) {
                        this.m_dumpRawData = runCommand.getOptionalBooleanOptValue((IOptsParser.IOpt)object);
                        continue;
                    }
                    if ("out".equals(string)) {
                        this.m_outFileName = object.getFirstValue();
                        continue;
                    }
                    if ("merge".equals(string)) {
                        this.m_outDataMerge = runCommand.getOptionalBooleanOptValue((IOptsParser.IOpt)object) ? Boolean.TRUE : Boolean.FALSE;
                        continue;
                    }
                    if ("r".equals(string)) {
                        this.m_reportTypes = Strings.merge(object.getValues(), ", \t\r\n", true);
                        continue;
                    }
                    if (!"ix".equals(string)) continue;
                    this.m_ixpath = runCommand.getListOptValue((IOptsParser.IOpt)object, ", \t\r\n", true);
                }
                if (!this.processFilePropertyOverrides()) {
                    return;
                }
                this.processCmdPropertyOverrides((IOptsParser.IOpts)object2);
            }
            catch (IOException iOException) {
                throw new EMMARuntimeException("ARGS_IO_FAILURE", iOException);
            }
            String[] stringArray2 = object2.getFreeArgs();
            if (this.m_jarMode) {
                if (stringArray2 == null || stringArray2.length == 0) {
                    this.usageexit((IOptsParser)stringArray, 1, "missing jar file name");
                    return;
                }
                object = new File(stringArray2[0]);
                try {
                    string = runCommand.openJarFile((File)object);
                }
                catch (IOException iOException) {
                    throw new EMMARuntimeException("ARGS_IO_FAILURE", iOException);
                }
                if (string == null) {
                    this.exit(true, "failed to load Main-Class manifest attribute from [" + ((File)object).getAbsolutePath() + "]", null, 2);
                    return;
                }
                this.m_appArgs = new String[stringArray2.length];
                System.arraycopy(stringArray2, 1, this.m_appArgs, 1, stringArray2.length - 1);
                this.m_appArgs[0] = string;
                this.m_classpath = new String[]{((File)object).getPath()};
            } else {
                if (stringArray2 == null || stringArray2.length == 0) {
                    this.usageexit((IOptsParser)stringArray, 1, "missing application class name");
                    return;
                }
                this.m_appArgs = stringArray2;
            }
            if (this.m_classpath == null) {
                this.usageexit((IOptsParser)stringArray, 1, "either '-cp' or '-jar' option is required");
                return;
            }
            if (this.m_reportTypes == null) {
                this.m_reportTypes = new String[]{"txt"};
            }
            stringArray = new String[this.m_appArgs.length - 1];
            System.arraycopy(this.m_appArgs, 1, stringArray, 0, stringArray.length);
            object2 = AppRunner.create(classLoader);
            ((Processor)object2).setAppName("EMMA");
            ((AppRunner)object2).setAppClass(this.m_appArgs[0], stringArray);
            ((AppRunner)object2).setCoveragePath(this.m_classpath, true);
            ((AppRunner)object2).setScanCoveragePath(this.m_scanCoveragePath);
            ((AppRunner)object2).setSourcePath(this.m_srcpath);
            ((AppRunner)object2).setInclExclFilter(this.m_ixpath);
            ((AppRunner)object2).setDumpSessionData(this.m_dumpRawData);
            ((AppRunner)object2).setSessionOutFile(this.m_outFileName);
            ((AppRunner)object2).setSessionOutMerge(this.m_outDataMerge);
            ((AppRunner)object2).setReportTypes(this.m_reportTypes);
            ((Processor)object2).setPropertyOverrides(this.m_propertyOverrides);
            ((AppRunner)object2).run();
        }
        catch (EMMARuntimeException eMMARuntimeException) {
            this.exit(true, eMMARuntimeException.getMessage(), eMMARuntimeException, 2);
            return;
        }
        catch (Throwable throwable) {
            this.exit(true, "unexpected failure: ", throwable, 2);
            return;
        }
        this.exit(false, null, null, 0);
    }

    protected runCommand(String string, String[] stringArray) {
        super(string, stringArray);
    }

    protected void initialize() {
        super.initialize();
    }

    protected String usageArgsMsg() {
        return "[options] class [args...] | -jar [options] jarfile [args...]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String openJarFile(File file) throws IOException {
        JarFile jarFile = null;
        try {
            String string;
            jarFile = new JarFile(file, false);
            Manifest manifest = jarFile.getManifest();
            if (manifest == null) {
                String string2 = null;
                return string2;
            }
            Attributes attributes = manifest.getMainAttributes();
            if (attributes == null) {
                String string3 = null;
                return string3;
            }
            String string4 = string = attributes.getValue(Attributes.Name.MAIN_CLASS);
            return string4;
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

