/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.jcd.cls.attribute;

import com.vladium.jcd.cls.attribute.Exception_info;
import com.vladium.jcd.cls.attribute.IExceptionHandlerTable;
import com.vladium.jcd.lib.UDataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

final class ExceptionHandlerTable
implements IExceptionHandlerTable {
    private List m_exceptions;

    public Exception_info get(int n) {
        return (Exception_info)this.m_exceptions.get(n);
    }

    public int size() {
        return this.m_exceptions.size();
    }

    public long length() {
        return 2 + (this.m_exceptions.size() << 3);
    }

    public Object clone() {
        try {
            ExceptionHandlerTable exceptionHandlerTable = (ExceptionHandlerTable)super.clone();
            int n = this.m_exceptions.size();
            exceptionHandlerTable.m_exceptions = new ArrayList(n);
            for (int i = 0; i < n; ++i) {
                exceptionHandlerTable.m_exceptions.add(((Exception_info)this.m_exceptions.get(i)).clone());
            }
            return exceptionHandlerTable;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
    }

    public void writeInClassFormat(UDataOutputStream uDataOutputStream) throws IOException {
        int n = this.m_exceptions.size();
        uDataOutputStream.writeU2(n);
        for (int i = 0; i < n; ++i) {
            this.get(i).writeInClassFormat(uDataOutputStream);
        }
    }

    public int add(Exception_info exception_info) {
        int n = this.m_exceptions.size();
        this.m_exceptions.add(exception_info);
        return n;
    }

    public Exception_info set(int n, Exception_info exception_info) {
        return this.m_exceptions.set(n, exception_info);
    }

    ExceptionHandlerTable(int n) {
        this.m_exceptions = n < 0 ? new ArrayList() : new ArrayList(n);
    }
}

