/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.logging;

import com.vladium.logging.ILogLevels;
import com.vladium.util.ClassLoaderResolver;
import com.vladium.util.Property;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;

public final class Logger
implements ILogLevels {
    private final int m_level;
    private final PrintWriter m_out;
    private final String m_prefix;
    private final Set m_classMask;
    private static final String PREFIX_TO_STRIP = "com.vladium.";
    private static final int PREFIX_TO_STRIP_LENGTH;
    private static final boolean FLUSH_LOG = true;
    private static final String COMMA_DELIMITERS = ", \t\r\n";
    private static final Logger STATIC_LOGGER;
    private static final ThreadLocalStack THREAD_LOCAL_STACK;

    public static Logger create(int n, PrintWriter printWriter, String string, Set set) {
        if (n < -1 || n > 7) {
            throw new IllegalArgumentException("invalid log level: " + n);
        }
        if (printWriter == null || printWriter.checkError()) {
            throw new IllegalArgumentException("null or corrupt input: out");
        }
        return new Logger(n, printWriter, string, set);
    }

    public static Logger create(int n, PrintWriter printWriter, String string, Set set, Logger logger) {
        if (logger == null) {
            return Logger.create(n, printWriter, string, set);
        }
        int n2 = n >= -1 ? n : logger.m_level;
        PrintWriter printWriter2 = printWriter != null && !printWriter.checkError() ? printWriter : logger.m_out;
        String string2 = string;
        Set set2 = set != null ? set : logger.m_classMask;
        return new Logger(n2, printWriter2, string2, set2);
    }

    public final boolean isLoggable(int n) {
        return n <= this.m_level;
    }

    public final boolean atINFO() {
        return 2 <= this.m_level;
    }

    public final boolean atVERBOSE() {
        return 3 <= this.m_level;
    }

    public final boolean atTRACE1() {
        return 4 <= this.m_level;
    }

    public final boolean atTRACE2() {
        return 5 <= this.m_level;
    }

    public final boolean atTRACE3() {
        return 6 <= this.m_level;
    }

    public final void warning(String string) {
        this._log(1, null, string, false);
    }

    public final void info(String string) {
        this._log(2, null, string, false);
    }

    public final void verbose(String string) {
        this._log(3, null, string, false);
    }

    public final void trace1(String string, String string2) {
        this._log(4, string, string2, true);
    }

    public final void trace2(String string, String string2) {
        this._log(5, string, string2, true);
    }

    public final void trace3(String string, String string2) {
        this._log(6, string, string2, true);
    }

    public final void log(int n, String string, boolean bl) {
        this._log(n, null, string, bl);
    }

    public final void log(int n, String string, String string2, boolean bl) {
        this._log(n, string, string2, bl);
    }

    public final void log(int n, String string, Throwable throwable) {
        this._log(n, null, string, throwable);
    }

    public final void log(int n, String string, String string2, Throwable throwable) {
        this._log(n, string, string2, throwable);
    }

    public PrintWriter getWriter() {
        return this.m_out;
    }

    public static Logger getLogger() {
        LinkedList linkedList = (LinkedList)THREAD_LOCAL_STACK.get();
        if (linkedList.isEmpty()) {
            return STATIC_LOGGER;
        }
        return (Logger)linkedList.getLast();
    }

    public static void push(Logger logger) {
        if (logger == null) {
            throw new IllegalArgumentException("null input: ctx");
        }
        LinkedList linkedList = (LinkedList)THREAD_LOCAL_STACK.get();
        linkedList.addLast(logger);
    }

    public static void pop(Logger logger) {
        LinkedList linkedList = (LinkedList)THREAD_LOCAL_STACK.get();
        try {
            Logger logger2 = (Logger)linkedList.getLast();
            if (logger2 != logger) {
                throw new IllegalStateException("invalid context being popped: " + logger);
            }
            linkedList.removeLast();
            logger2.cleanup();
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new IllegalStateException("empty logger context stack on thread [" + Thread.currentThread() + "]: " + noSuchElementException);
        }
    }

    public static int stringToLevel(String string) {
        if ("severe".equalsIgnoreCase(string) || "silent".equalsIgnoreCase(string)) {
            return 0;
        }
        if ("warning".equalsIgnoreCase(string) || "quiet".equalsIgnoreCase(string)) {
            return 1;
        }
        if ("info".equalsIgnoreCase(string)) {
            return 2;
        }
        if ("verbose".equalsIgnoreCase(string)) {
            return 3;
        }
        if ("trace1".equalsIgnoreCase(string)) {
            return 4;
        }
        if ("trace2".equalsIgnoreCase(string)) {
            return 5;
        }
        if ("trace3".equalsIgnoreCase(string)) {
            return 6;
        }
        if ("none".equalsIgnoreCase(string)) {
            return -1;
        }
        if ("all".equalsIgnoreCase(string)) {
            return 7;
        }
        int n = Integer.MIN_VALUE;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n >= -1 && n <= 7) {
            return n;
        }
        return 2;
    }

    private Logger(int n, PrintWriter printWriter, String string, Set set) {
        this.m_level = n;
        this.m_out = printWriter;
        this.m_prefix = string;
        this.m_classMask = set;
    }

    private void cleanup() {
        this.m_out.flush();
    }

    private void _log(int n, String string, String string2, boolean bl) {
        if (n <= this.m_level && n >= 0) {
            Object object;
            Class clazz = bl ? ClassLoaderResolver.getCallerClass(2) : null;
            StringBuffer stringBuffer = new StringBuffer(this.m_prefix != null ? this.m_prefix + ": " : "");
            if (clazz != null || string != null) {
                stringBuffer.append("[");
                if (clazz != null) {
                    object = clazz.getName();
                    if (((String)object).startsWith(PREFIX_TO_STRIP)) {
                        object = ((String)object).substring(PREFIX_TO_STRIP_LENGTH);
                    }
                    Object object2 = object;
                    int n2 = ((String)object).indexOf(36);
                    if (n2 > 0) {
                        object2 = ((String)object).substring(0, n2);
                    }
                    if (this.m_classMask == null || this.m_classMask.contains(object2)) {
                        stringBuffer.append((String)object);
                    } else {
                        return;
                    }
                }
                if (string != null) {
                    stringBuffer.append("::");
                    stringBuffer.append(string);
                }
                stringBuffer.append("] ");
            }
            object = this.m_out;
            if (string2 != null) {
                stringBuffer.append(string2);
            }
            ((PrintWriter)object).println(stringBuffer);
            ((PrintWriter)object).flush();
        }
    }

    private void _log(int n, String string, String string2, Throwable throwable) {
        if (n <= this.m_level && n >= 0) {
            Object object;
            Object object2;
            Class clazz = ClassLoaderResolver.getCallerClass(2);
            StringBuffer stringBuffer = new StringBuffer(this.m_prefix != null ? this.m_prefix + ": " : "");
            if (clazz != null || string != null) {
                stringBuffer.append("[");
                if (clazz != null) {
                    object2 = clazz.getName();
                    if (((String)object2).startsWith(PREFIX_TO_STRIP)) {
                        object2 = ((String)object2).substring(PREFIX_TO_STRIP_LENGTH);
                    }
                    object = object2;
                    int n2 = ((String)object2).indexOf(36);
                    if (n2 > 0) {
                        object = ((String)object2).substring(0, n2);
                    }
                    if (this.m_classMask == null || this.m_classMask.contains(object)) {
                        stringBuffer.append((String)object2);
                    } else {
                        return;
                    }
                }
                if (string != null) {
                    stringBuffer.append("::");
                    stringBuffer.append(string);
                }
                stringBuffer.append("] ");
            }
            object2 = this.m_out;
            if (string2 != null) {
                stringBuffer.append(string2);
            }
            if (throwable != null) {
                object = new StringWriter();
                PrintWriter printWriter = new PrintWriter((Writer)object);
                throwable.printStackTrace(printWriter);
                printWriter.flush();
                stringBuffer.append(((StringWriter)object).toString());
            }
            ((PrintWriter)object2).println(stringBuffer);
            ((PrintWriter)object2).flush();
        }
    }

    static {
        StringTokenizer stringTokenizer;
        PREFIX_TO_STRIP_LENGTH = PREFIX_TO_STRIP.length();
        THREAD_LOCAL_STACK = new ThreadLocalStack();
        Properties properties = Property.getAppProperties("emma", Logger.class.getClassLoader());
        String string = properties.getProperty("verbosity.level", "info");
        int n = Logger.stringToLevel(string);
        String string2 = properties.getProperty("verbosity.filter");
        HashSet<String> hashSet = null;
        if (string2 != null && (stringTokenizer = new StringTokenizer(string2, COMMA_DELIMITERS)).countTokens() > 0) {
            hashSet = new HashSet<String>(stringTokenizer.countTokens());
            while (stringTokenizer.hasMoreTokens()) {
                hashSet.add(stringTokenizer.nextToken());
            }
        }
        string = hashSet;
        STATIC_LOGGER = Logger.create(n, new PrintWriter(System.out, false), "EMMA", (Set)((Object)string));
    }

    private static final class ThreadLocalStack
    extends InheritableThreadLocal {
        private ThreadLocalStack() {
        }

        protected Object initialValue() {
            return new LinkedList();
        }
    }
}

