/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib;

import com.android.annotations.NonNull;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;

public abstract class AndroidTargetHash {
    private static final String PLATFORM_HASH_PREFIX = "android-";
    static final String ADD_ON_FORMAT = "%s:%s:%s";
    static final String PLATFORM_HASH = "android-%s";

    public static String getPlatformHashString(@NonNull AndroidVersion version) {
        return String.format(PLATFORM_HASH, version.getApiString());
    }

    public static String getAddonHashString(@NonNull String addonVendor, @NonNull String addonName, @NonNull AndroidVersion version) {
        return String.format(ADD_ON_FORMAT, addonVendor, addonName, version.getApiString());
    }

    public static String getTargetHashString(@NonNull IAndroidTarget target) {
        if (target.isPlatform()) {
            return AndroidTargetHash.getPlatformHashString(target.getVersion());
        }
        return AndroidTargetHash.getAddonHashString(target.getVendor(), target.getName(), target.getVersion());
    }
}

