/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.gltrace.views.detail;

import com.android.ide.eclipse.gltrace.GLEnum;
import com.android.ide.eclipse.gltrace.state.GLCompositeProperty;
import com.android.ide.eclipse.gltrace.state.GLStateType;
import com.android.ide.eclipse.gltrace.state.IGLProperty;
import com.android.ide.eclipse.gltrace.views.detail.IStateDetailProvider;
import com.google.common.base.Joiner;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class ShaderUniformDetailsProvider
implements IStateDetailProvider {
    private Text mTextControl;
    private static final Joiner JOINER = Joiner.on((String)", ");

    @Override
    public boolean isApplicable(IGLProperty iGLProperty) {
        return this.getShaderUniformProperty(iGLProperty) != null;
    }

    @Override
    public void createControl(Composite composite) {
        this.mTextControl = new Text(composite, 2122);
        this.mTextControl.setEditable(false);
    }

    @Override
    public void disposeControl() {
    }

    @Override
    public Control getControl() {
        return this.mTextControl;
    }

    @Override
    public void updateControl(IGLProperty iGLProperty) {
        IGLProperty iGLProperty2 = this.getShaderUniformProperty(iGLProperty);
        if (iGLProperty2 instanceof GLCompositeProperty) {
            GLCompositeProperty gLCompositeProperty = (GLCompositeProperty)iGLProperty2;
            IGLProperty iGLProperty3 = gLCompositeProperty.getProperty(GLStateType.UNIFORM_NAME);
            IGLProperty iGLProperty4 = gLCompositeProperty.getProperty(GLStateType.UNIFORM_TYPE);
            IGLProperty iGLProperty5 = gLCompositeProperty.getProperty(GLStateType.UNIFORM_VALUE);
            String string = (String)iGLProperty3.getValue();
            GLEnum gLEnum = (GLEnum)((Object)iGLProperty4.getValue());
            Object object = iGLProperty5.getValue();
            this.mTextControl.setText(this.formatUniform(string, gLEnum, object));
            this.mTextControl.setEnabled(true);
        } else {
            this.mTextControl.setText("");
            this.mTextControl.setEnabled(false);
        }
    }

    private String formatUniform(String string, GLEnum gLEnum, Object object) {
        String string2;
        switch (gLEnum) {
            case GL_INT: 
            case GL_FLOAT: 
            case GL_FLOAT_VEC2: 
            case GL_FLOAT_VEC3: 
            case GL_FLOAT_VEC4: 
            case GL_INT_VEC2: 
            case GL_INT_VEC3: 
            case GL_INT_VEC4: 
            case GL_BOOL: 
            case GL_BOOL_VEC2: 
            case GL_BOOL_VEC3: 
            case GL_BOOL_VEC4: {
                string2 = this.formatVector(object);
                break;
            }
            case GL_FLOAT_MAT2: {
                string2 = this.formatMatrix(2, object);
                break;
            }
            case GL_FLOAT_MAT3: {
                string2 = this.formatMatrix(3, object);
                break;
            }
            case GL_FLOAT_MAT4: {
                string2 = this.formatMatrix(4, object);
                break;
            }
            default: {
                string2 = object.toString();
            }
        }
        return String.format("%s %s = %s", new Object[]{gLEnum, string, string2});
    }

    private String formatVector(Object object) {
        if (object instanceof List) {
            List list = (List)object;
            StringBuilder stringBuilder = new StringBuilder(list.size() * 4);
            stringBuilder.append('[');
            JOINER.appendTo(stringBuilder, (Iterable)list);
            stringBuilder.append(']');
            return stringBuilder.toString();
        }
        return object.toString();
    }

    private String formatMatrix(int n, Object object) {
        if (object instanceof List) {
            List list = (List)object;
            if (list.size() != n * n) {
                return this.formatVector(object);
            }
            StringBuilder stringBuilder = new StringBuilder(list.size() * 4);
            stringBuilder.append('[');
            stringBuilder.append('\n');
            int n2 = 0;
            while (n2 < n) {
                stringBuilder.append("    ");
                JOINER.appendTo(stringBuilder, list.subList(n2 * n, (n2 + 1) * n));
                stringBuilder.append('\n');
                ++n2;
            }
            stringBuilder.append(']');
            return stringBuilder.toString();
        }
        return object.toString();
    }

    private IGLProperty getShaderUniformProperty(IGLProperty iGLProperty) {
        if (iGLProperty.getType() == GLStateType.PER_UNIFORM_STATE) {
            return iGLProperty;
        }
        if ((iGLProperty = iGLProperty.getParent()) != null && iGLProperty.getType() == GLStateType.PER_UNIFORM_STATE) {
            return iGLProperty;
        }
        return null;
    }

    @Override
    public List<IContributionItem> getToolBarItems() {
        return Collections.emptyList();
    }
}

