/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint;

import com.android.tools.lint.LintCliClient;
import com.android.tools.lint.Main;
import com.android.tools.lint.Reporter;
import com.android.tools.lint.Warning;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Position;
import com.android.tools.lint.detector.api.Severity;
import com.google.common.annotations.Beta;
import java.io.IOException;
import java.io.Writer;
import java.util.List;

@Beta
public class TextReporter
extends Reporter {
    private final Writer mWriter;
    private final boolean mClose;

    public TextReporter(LintCliClient client, Writer writer, boolean close) {
        super(client, null);
        this.mWriter = writer;
        this.mClose = close;
    }

    @Override
    public void write(int errorCount, int warningCount, List<Warning> issues) throws IOException {
        boolean abbreviate = this.mClient.getDriver().isAbbreviating();
        StringBuilder output = new StringBuilder(issues.size() * 200);
        if (issues.isEmpty()) {
            this.mWriter.write(10);
            this.mWriter.write("No issues found.");
            this.mWriter.write(10);
            this.mWriter.flush();
        } else {
            for (Warning warning : issues) {
                Location location;
                Severity severity;
                int startLength = output.length();
                if (warning.path != null) {
                    output.append(warning.path);
                    output.append(':');
                    if (warning.line >= 0) {
                        output.append(Integer.toString(warning.line + 1));
                        output.append(':');
                    }
                    if (startLength < output.length()) {
                        output.append(' ');
                    }
                }
                if ((severity = warning.severity) == Severity.FATAL) {
                    severity = Severity.ERROR;
                }
                output.append(severity.getDescription());
                output.append(':');
                output.append(' ');
                output.append(warning.message);
                if (warning.issue != null) {
                    output.append(' ').append('[');
                    output.append(warning.issue.getId());
                    output.append(']');
                }
                output.append('\n');
                if (warning.errorLine != null && !warning.errorLine.isEmpty()) {
                    output.append(warning.errorLine);
                }
                if (warning.location == null || warning.location.getSecondary() == null) continue;
                for (location = warning.location.getSecondary(); location != null; location = location.getSecondary()) {
                    int line;
                    if (location.getMessage() == null || location.getMessage().isEmpty()) continue;
                    output.append("    ");
                    String path = this.mClient.getDisplayPath(warning.project, location.getFile());
                    output.append(path);
                    Position start = location.getStart();
                    if (start != null && (line = start.getLine()) >= 0) {
                        output.append(':');
                        output.append(Integer.toString(line + 1));
                    }
                    if (location.getMessage() != null && !location.getMessage().isEmpty()) {
                        output.append(':');
                        output.append(' ');
                        output.append(location.getMessage());
                    }
                    output.append('\n');
                }
                if (abbreviate) continue;
                StringBuilder sb = new StringBuilder(100);
                sb.append("Also affects: ");
                int begin = sb.length();
                for (location = warning.location.getSecondary(); location != null; location = location.getSecondary()) {
                    int line;
                    if (location.getMessage() != null && location.getMessage().isEmpty()) continue;
                    if (sb.length() > begin) {
                        sb.append(", ");
                    }
                    String path = this.mClient.getDisplayPath(warning.project, location.getFile());
                    sb.append(path);
                    Position start = location.getStart();
                    if (start == null || (line = start.getLine()) < 0) continue;
                    sb.append(':');
                    sb.append(Integer.toString(line + 1));
                }
                String wrapped = Main.wrap(sb.toString(), 78, "     ");
                output.append(wrapped);
            }
            this.mWriter.write(output.toString());
            this.mWriter.write(String.format("%1$d errors, %2$d warnings", errorCount, warningCount));
            this.mWriter.write(10);
            this.mWriter.flush();
            if (this.mClose) {
                this.mWriter.close();
            }
        }
    }
}

