/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.Collection;
import java.util.Collections;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class GridLayoutDetector
extends LayoutDetector {
    public static final Issue ISSUE = Issue.create("GridLayout", "GridLayout validation", "Checks for potential GridLayout errors like declaring rows and columns outside the declared grid dimensions", "Declaring a layout_row or layout_column that falls outside the declared size of a GridLayout's `rowCount` or `columnCount` is usually an unintentional error.", Category.CORRECTNESS, 4, Severity.FATAL, new Implementation(GridLayoutDetector.class, Scope.RESOURCE_FILE_SCOPE));

    @Override
    @NonNull
    public Speed getSpeed() {
        return Speed.FAST;
    }

    @Override
    public Collection<String> getApplicableElements() {
        return Collections.singletonList("GridLayout");
    }

    private static int getInt(Element element, String attribute, int defaultValue) {
        String valueString = element.getAttributeNS("http://schemas.android.com/apk/res/android", attribute);
        if (valueString != null && !valueString.isEmpty()) {
            try {
                return Integer.decode(valueString);
            }
            catch (NumberFormatException nufe) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    @Override
    public void visitElement(@NonNull XmlContext context, @NonNull Element element) {
        int declaredRowCount = GridLayoutDetector.getInt(element, "rowCount", -1);
        int declaredColumnCount = GridLayoutDetector.getInt(element, "columnCount", -1);
        if (declaredColumnCount != -1 || declaredRowCount != -1) {
            for (Element child : LintUtils.getChildren(element)) {
                int row;
                Attr node;
                int column;
                if (declaredColumnCount != -1 && (column = GridLayoutDetector.getInt(child, "layout_column", -1)) >= declaredColumnCount) {
                    node = child.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "layout_column");
                    context.report(ISSUE, node, context.getLocation(node), String.format("Column attribute (%1$d) exceeds declared grid column count (%2$d)", column, declaredColumnCount), null);
                }
                if (declaredRowCount == -1 || (row = GridLayoutDetector.getInt(child, "layout_row", -1)) <= declaredRowCount) continue;
                node = child.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "layout_row");
                context.report(ISSUE, node, context.getLocation(node), String.format("Row attribute (%1$d) exceeds declared grid row count (%2$d)", row, declaredRowCount), null);
            }
        }
    }
}

