/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.resources.ResourceFolderType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.Pair;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.ast.AstVisitor;
import lombok.ast.ClassDeclaration;
import lombok.ast.CompilationUnit;
import lombok.ast.Expression;
import lombok.ast.ForwardingAstVisitor;
import lombok.ast.MethodInvocation;
import lombok.ast.Node;
import lombok.ast.PackageDeclaration;
import lombok.ast.Select;
import lombok.ast.StrictListAccessor;
import lombok.ast.VariableReference;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class OverdrawDetector
extends LayoutDetector
implements Detector.JavaScanner {
    private static final String R_STYLE_PREFIX = "R.style.";
    private static final String SET_THEME = "setTheme";
    public static final Issue ISSUE = Issue.create("Overdraw", "Overdraw: Painting regions more than once", "Looks for overdraw issues (where a view is painted only to be fully painted over)", "If you set a background drawable on a root view, then you should use a custom theme where the theme background is null. Otherwise, the theme background will be painted first, only to have your custom background completely cover it; this is called \"overdraw\".\n\nNOTE: This detector relies on figuring out which layouts are associated with which activities based on scanning the Java code, and it's currently doing that using an inexact pattern matching algorithm. Therefore, it can incorrectly conclude which activity the layout is associated with and then wrongly complain that a background-theme is hidden.\n\nIf you want your custom background on multiple pages, then you should consider making a custom theme with your custom background and just using that theme instead of a root element background.\n\nOf course it's possible that your custom drawable is translucent and you want it to be mixed with the background. However, you will get better performance if you pre-mix the background with your drawable and use that resulting image or color as a custom theme background instead.\n", Category.PERFORMANCE, 3, Severity.WARNING, new Implementation(OverdrawDetector.class, EnumSet.of(Scope.MANIFEST, Scope.JAVA_FILE, Scope.ALL_RESOURCE_FILES)));
    private Map<String, String> mActivityToTheme;
    private String mManifestTheme;
    private Map<String, List<String>> mLayoutToActivity;
    private List<String> mBlankThemes;
    private Set<String> mActivities;
    private List<String> mValidDrawables;
    private List<Pair<Location, String>> mRootAttributes;

    @Override
    public boolean appliesTo(@NonNull ResourceFolderType folderType) {
        return super.appliesTo(folderType) || folderType == ResourceFolderType.VALUES || folderType == ResourceFolderType.DRAWABLE;
    }

    @Override
    public boolean appliesTo(@NonNull Context context, @NonNull File file) {
        return LintUtils.isXmlFile(file) || LintUtils.endsWith(file.getName(), ".java");
    }

    @Override
    @NonNull
    public Speed getSpeed() {
        return Speed.FAST;
    }

    private boolean isBlankTheme(String name) {
        if (name.startsWith("@android:style/Theme_") && (name.contains("NoFrame") || name.contains("Theme_Wallpaper") || name.contains("Theme_Holo_Wallpaper") || name.contains("Theme_Translucent") || name.contains("Theme_Dialog_NoFrame") || name.contains("Theme_Holo_Dialog_Alert") || name.contains("Theme_Holo_Light_Dialog_Alert") || name.contains("Theme_Dialog_Alert") || name.contains("Theme_Panel") || name.contains("Theme_Light_Panel") || name.contains("Theme_Holo_Panel") || name.contains("Theme_Holo_Light_Panel"))) {
            return true;
        }
        return this.mBlankThemes != null && this.mBlankThemes.contains(name);
    }

    @Override
    public void afterCheckProject(@NonNull Context context) {
        if (this.mRootAttributes != null) {
            for (Pair<Location, String> pair : this.mRootAttributes) {
                String theme;
                Location location = (Location)pair.getFirst();
                Object clientData = location.getClientData();
                if (clientData instanceof org.w3c.dom.Node && context.getDriver().isSuppressed(ISSUE, (org.w3c.dom.Node)clientData)) {
                    return;
                }
                String layoutName = location.getFile().getName();
                if (LintUtils.endsWith(layoutName, ".xml")) {
                    layoutName = layoutName.substring(0, layoutName.length() - ".xml".length());
                }
                if ((theme = this.getTheme(context, layoutName)) != null && this.isBlankTheme(theme)) continue;
                String drawable = (String)pair.getSecond();
                String message = String.format("Possible overdraw: Root element paints background %1$s with a theme that also paints a background (inferred theme is %2$s)", drawable, theme);
                context.report(ISSUE, location, message, null);
            }
        }
    }

    private String getTheme(Context context, String layoutName) {
        List<String> activities;
        if (this.mActivityToTheme != null && this.mLayoutToActivity != null && (activities = this.mLayoutToActivity.get(layoutName)) != null) {
            for (String activity : activities) {
                String theme = this.mActivityToTheme.get(activity);
                if (theme == null) continue;
                return theme;
            }
        }
        if (this.mManifestTheme != null) {
            return this.mManifestTheme;
        }
        Project project = context.getMainProject();
        int apiLevel = project.getTargetSdk();
        if (apiLevel == -1) {
            apiLevel = project.getMinSdk();
        }
        if (apiLevel >= 11) {
            return "@android:style/Theme.Holo";
        }
        return "@android:style/Theme";
    }

    @Override
    public void visitAttribute(@NonNull XmlContext context, @NonNull Attr attribute) {
        Element documentElement = attribute.getOwnerDocument().getDocumentElement();
        if (documentElement == attribute.getOwnerElement()) {
            String background = attribute.getValue();
            if (this.mValidDrawables != null && this.mValidDrawables.contains(background)) {
                return;
            }
            if (background.equals("@android:color/transparent")) {
                return;
            }
            if (background.startsWith("@android:drawable/")) {
                return;
            }
            String name = context.file.getName();
            if (name.contains("list_") || name.contains("_item")) {
                return;
            }
            if (!context.getProject().getReportIssues()) {
                return;
            }
            Location location = context.getLocation(attribute);
            location.setClientData(attribute);
            if (this.mRootAttributes == null) {
                this.mRootAttributes = new ArrayList<Pair<Location, String>>();
            }
            this.mRootAttributes.add((Pair<Location, String>)Pair.of((Object)location, (Object)attribute.getValue()));
            String activity = documentElement.getAttributeNS("http://schemas.android.com/tools", "context");
            if (activity != null && !activity.isEmpty()) {
                if (activity.startsWith(".")) {
                    activity = context.getProject().getPackage() + activity;
                }
                this.registerLayoutActivity(LintUtils.getLayoutName(context.file), activity);
            }
        }
    }

    @Override
    public Collection<String> getApplicableAttributes() {
        return Collections.singletonList("background");
    }

    @Override
    public Collection<String> getApplicableElements() {
        return Arrays.asList("activity", "application", "style", "bitmap");
    }

    @Override
    public void beforeCheckFile(@NonNull Context context) {
        File parent;
        ResourceFolderType type;
        if (LintUtils.endsWith(context.file.getName(), ".xml") && (type = ResourceFolderType.getFolderType((String)(parent = context.file.getParentFile()).getName())) == ResourceFolderType.DRAWABLE) {
            if (this.mValidDrawables == null) {
                this.mValidDrawables = new ArrayList<String>();
            }
            String resource = OverdrawDetector.getDrawableResource(context.file);
            this.mValidDrawables.add(resource);
        }
    }

    @Override
    public void visitElement(@NonNull XmlContext context, @NonNull Element element) {
        String tag = element.getTagName();
        if (tag.equals("style")) {
            this.scanTheme(element);
        } else if (tag.equals("activity")) {
            this.scanActivity(context, element);
        } else if (tag.equals("application")) {
            if (element.hasAttributeNS("http://schemas.android.com/apk/res/android", "theme")) {
                this.mManifestTheme = element.getAttributeNS("http://schemas.android.com/apk/res/android", "theme");
            }
        } else if (tag.equals("bitmap")) {
            this.scanBitmap(context, element);
        }
    }

    private static String getDrawableResource(File drawableFile) {
        String resource = drawableFile.getName();
        if (LintUtils.endsWith(resource, ".xml")) {
            resource = resource.substring(0, resource.length() - ".xml".length());
        }
        return "@drawable/" + resource;
    }

    private void scanBitmap(Context context, Element element) {
        String tileMode = element.getAttributeNS("http://schemas.android.com/apk/res/android", "tileMode");
        if (!tileMode.equals("disabled") && !tileMode.isEmpty() && this.mValidDrawables != null) {
            String resource = OverdrawDetector.getDrawableResource(context.file);
            this.mValidDrawables.remove(resource);
        }
    }

    private void scanActivity(Context context, Element element) {
        String pkg;
        String name = element.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
        if (name.indexOf(36) != -1) {
            name = name.replace('$', '.');
        }
        if (name.startsWith(".") && (pkg = context.getProject().getPackage()) != null && !pkg.isEmpty()) {
            name = pkg + name;
        }
        if (this.mActivities == null) {
            this.mActivities = new HashSet<String>();
        }
        this.mActivities.add(name);
        String theme = element.getAttributeNS("http://schemas.android.com/apk/res/android", "theme");
        if (theme != null && !theme.isEmpty()) {
            if (this.mActivityToTheme == null) {
                this.mActivityToTheme = new HashMap<String, String>();
            }
            this.mActivityToTheme.put(name, theme.replace('.', '_'));
        }
    }

    private void scanTheme(Element element) {
        int index;
        String styleName = element.getAttribute("name");
        String parent = element.getAttribute("parent");
        if (parent == null) {
            parent = "";
        }
        if (parent.isEmpty() && (index = styleName.lastIndexOf(46)) != -1) {
            parent = styleName.substring(0, index);
        }
        parent = parent.replace('.', '_');
        String resource = "@style/" + styleName.replace('.', '_');
        NodeList items = element.getChildNodes();
        int n = items.getLength();
        for (int i = 0; i < n; ++i) {
            Element item;
            String name;
            if (items.item(i).getNodeType() != 1 || !(name = (item = (Element)items.item(i)).getAttribute("name")).equals("android:windowBackground")) continue;
            NodeList textNodes = item.getChildNodes();
            int m = textNodes.getLength();
            for (int j = 0; j < m; ++j) {
                String text;
                String trim;
                org.w3c.dom.Node textNode = textNodes.item(j);
                if (textNode.getNodeType() != 3 || (trim = (text = textNode.getNodeValue()).trim()).isEmpty() || !trim.equals("@null") && !trim.equals("@android:color/transparent") && (this.mValidDrawables == null || !this.mValidDrawables.contains(trim))) continue;
                if (this.mBlankThemes == null) {
                    this.mBlankThemes = new ArrayList<String>();
                }
                this.mBlankThemes.add(resource);
            }
            return;
        }
        if (this.isBlankTheme(parent)) {
            if (this.mBlankThemes == null) {
                this.mBlankThemes = new ArrayList<String>();
            }
            this.mBlankThemes.add(resource);
        }
    }

    private void registerLayoutActivity(String layout, String classFqn) {
        List<String> list;
        if (this.mLayoutToActivity == null) {
            this.mLayoutToActivity = new HashMap<String, List<String>>();
        }
        if ((list = this.mLayoutToActivity.get(layout)) == null) {
            list = new ArrayList<String>();
            this.mLayoutToActivity.put(layout, list);
        }
        list.add(classFqn);
    }

    @Override
    public List<Class<? extends Node>> getApplicableNodeTypes() {
        return null;
    }

    @Override
    public AstVisitor createJavaVisitor(@NonNull JavaContext context) {
        if (!context.getProject().getReportIssues()) {
            return null;
        }
        return new OverdrawVisitor();
    }

    private class OverdrawVisitor
    extends ForwardingAstVisitor {
        private static final String ACTIVITY = "Activity";
        private String mClassFqn;

        private OverdrawVisitor() {
        }

        public boolean visitClassDeclaration(ClassDeclaration node) {
            String name = node.astName().astValue();
            if (OverdrawDetector.this.mActivities != null && OverdrawDetector.this.mActivities.contains(this.mClassFqn) || name.endsWith(ACTIVITY) || node.astExtending() != null && node.astExtending().getTypeName().endsWith(ACTIVITY)) {
                String packageName = "";
                if (node.getParent() instanceof CompilationUnit) {
                    CompilationUnit compilationUnit = (CompilationUnit)node.getParent();
                    PackageDeclaration packageDeclaration = compilationUnit.astPackageDeclaration();
                    if (packageDeclaration == null) {
                        return true;
                    }
                    packageName = packageDeclaration.getPackageName();
                }
                this.mClassFqn = (!packageName.isEmpty() ? packageName + '.' : "") + name;
                return false;
            }
            return true;
        }

        public boolean visitSelect(Select node) {
            if (node.astIdentifier().astValue().equals("layout") && node.astOperand() instanceof VariableReference && ((VariableReference)node.astOperand()).astIdentifier().astValue().equals("R") && node.getParent() instanceof Select) {
                String layout = ((Select)node.getParent()).astIdentifier().astValue();
                OverdrawDetector.this.registerLayoutActivity(layout, this.mClassFqn);
            }
            return false;
        }

        public boolean visitMethodInvocation(MethodInvocation node) {
            String resource;
            Expression arg;
            StrictListAccessor args;
            if (node.astName().astValue().equals(OverdrawDetector.SET_THEME) && (args = node.astArguments()).size() == 1 && (arg = (Expression)args.first()) instanceof Select && (resource = arg.toString()).startsWith(OverdrawDetector.R_STYLE_PREFIX)) {
                if (OverdrawDetector.this.mActivityToTheme == null) {
                    OverdrawDetector.this.mActivityToTheme = new HashMap();
                }
                String name = ((Select)arg).astIdentifier().astValue();
                OverdrawDetector.this.mActivityToTheme.put(this.mClassFqn, "@style/" + name);
            }
            return false;
        }
    }
}

