/*
 * Decompiled with CFR 0.152.
 */
package com.android.hierarchyviewerlib.ui;

import com.android.ddmuilib.ImageLoader;
import com.android.hierarchyviewerlib.HierarchyViewerDirector;
import com.android.hierarchyviewerlib.device.IHvDevice;
import com.android.hierarchyviewerlib.models.DeviceSelectionModel;
import com.android.hierarchyviewerlib.models.Window;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class DeviceSelector
extends Composite
implements DeviceSelectionModel.IWindowChangeListener,
SelectionListener {
    private TreeViewer mTreeViewer;
    private Tree mTree;
    private DeviceSelectionModel mModel;
    private Font mBoldFont;
    private Image mDeviceImage;
    private Image mEmulatorImage;
    private static final int ICON_WIDTH = 16;
    private boolean mDoTreeViewStuff;
    private boolean mDoPixelPerfectStuff;
    private DisposeListener mDisposeListener = new DisposeListener(){

        public void widgetDisposed(DisposeEvent e) {
            DeviceSelector.this.mModel.removeWindowChangeListener(DeviceSelector.this);
            DeviceSelector.this.mBoldFont.dispose();
        }
    };
    private ControlListener mControlListener = new ControlAdapter(){
        private boolean noInput = false;

        public void controlResized(ControlEvent e) {
            if (DeviceSelector.this.getBounds().height <= 38) {
                DeviceSelector.this.mTreeViewer.setInput(null);
                this.noInput = true;
            } else if (this.noInput) {
                DeviceSelector.this.mTreeViewer.setInput(DeviceSelector.this.mModel);
                this.noInput = false;
            }
        }
    };

    public DeviceSelector(Composite parent, boolean doTreeViewStuff, boolean doPixelPerfectStuff) {
        super(parent, 0);
        this.mDoTreeViewStuff = doTreeViewStuff;
        this.mDoPixelPerfectStuff = doPixelPerfectStuff;
        this.setLayout((Layout)new FillLayout());
        this.mTreeViewer = new TreeViewer(this, 4);
        this.mTreeViewer.setAutoExpandLevel(-1);
        this.mTree = this.mTreeViewer.getTree();
        this.mTree.setLinesVisible(true);
        this.mTree.addSelectionListener((SelectionListener)this);
        this.addDisposeListener(this.mDisposeListener);
        this.loadResources();
        this.mModel = DeviceSelectionModel.getModel();
        ContentProvider contentProvider = new ContentProvider();
        this.mTreeViewer.setContentProvider(contentProvider);
        this.mTreeViewer.setLabelProvider(contentProvider);
        this.mModel.addWindowChangeListener(this);
        this.mTreeViewer.setInput(this.mModel);
        this.addControlListener(this.mControlListener);
    }

    public void loadResources() {
        Display display = Display.getDefault();
        Font systemFont = display.getSystemFont();
        FontData[] fontData = systemFont.getFontData();
        FontData[] newFontData = new FontData[fontData.length];
        for (int i = 0; i < fontData.length; ++i) {
            newFontData[i] = new FontData(fontData[i].getName(), fontData[i].getHeight(), fontData[i].getStyle() | 1);
        }
        this.mBoldFont = new Font((Device)Display.getDefault(), newFontData);
        ImageLoader loader = ImageLoader.getDdmUiLibLoader();
        this.mDeviceImage = loader.loadImage(display, "device.png", 16, 16, display.getSystemColor(3));
        this.mEmulatorImage = loader.loadImage(display, "emulator.png", 16, 16, display.getSystemColor(9));
    }

    public boolean setFocus() {
        return this.mTree.setFocus();
    }

    public void setMode(boolean doTreeViewStuff, boolean doPixelPerfectStuff) {
        if (this.mDoTreeViewStuff != doTreeViewStuff || this.mDoPixelPerfectStuff != doPixelPerfectStuff) {
            final boolean expandAll = !this.mDoTreeViewStuff && doTreeViewStuff;
            this.mDoTreeViewStuff = doTreeViewStuff;
            this.mDoPixelPerfectStuff = doPixelPerfectStuff;
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    DeviceSelector.this.mTreeViewer.refresh();
                    if (expandAll) {
                        DeviceSelector.this.mTreeViewer.expandAll();
                    }
                }
            });
        }
    }

    @Override
    public void deviceConnected(final IHvDevice device) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                DeviceSelector.this.mTreeViewer.refresh();
                DeviceSelector.this.mTreeViewer.setExpandedState(device, true);
            }
        });
    }

    @Override
    public void deviceChanged(final IHvDevice device) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                TreeSelection selection = (TreeSelection)DeviceSelector.this.mTreeViewer.getSelection();
                DeviceSelector.this.mTreeViewer.refresh(device);
                if (selection.getFirstElement() instanceof Window && ((Window)selection.getFirstElement()).getDevice() == device) {
                    DeviceSelector.this.mTreeViewer.setSelection(selection, true);
                }
            }
        });
    }

    @Override
    public void deviceDisconnected(IHvDevice device) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                DeviceSelector.this.mTreeViewer.refresh();
            }
        });
    }

    @Override
    public void focusChanged(final IHvDevice device) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                TreeSelection selection = (TreeSelection)DeviceSelector.this.mTreeViewer.getSelection();
                DeviceSelector.this.mTreeViewer.refresh(device);
                if (selection.getFirstElement() instanceof Window && ((Window)selection.getFirstElement()).getDevice() == device) {
                    DeviceSelector.this.mTreeViewer.setSelection(selection, true);
                }
            }
        });
    }

    @Override
    public void selectionChanged(IHvDevice device, Window window) {
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        Object selection = ((TreeItem)e.item).getData();
        if (selection instanceof IHvDevice && this.mDoPixelPerfectStuff) {
            HierarchyViewerDirector.getDirector().loadPixelPerfectData((IHvDevice)selection);
        } else if (selection instanceof Window && this.mDoTreeViewStuff) {
            HierarchyViewerDirector.getDirector().loadViewTreeData((Window)selection);
        }
    }

    public void widgetSelected(SelectionEvent e) {
        TreeItem item = (TreeItem)e.item;
        if (item == null) {
            return;
        }
        Object selection = item.getData();
        if (selection instanceof IHvDevice) {
            this.mModel.setSelection((IHvDevice)selection, null);
        } else if (selection instanceof Window) {
            this.mModel.setSelection(((Window)selection).getHvDevice(), (Window)selection);
        }
    }

    private class ContentProvider
    implements ITreeContentProvider,
    ILabelProvider,
    IFontProvider {
        private ContentProvider() {
        }

        @Override
        public Object[] getChildren(Object parentElement) {
            Object[] list;
            if (parentElement instanceof IHvDevice && DeviceSelector.this.mDoTreeViewStuff && (list = DeviceSelector.this.mModel.getWindows((IHvDevice)parentElement)) != null) {
                return list;
            }
            return new Object[0];
        }

        @Override
        public Object getParent(Object element) {
            if (element instanceof Window) {
                return ((Window)element).getDevice();
            }
            return null;
        }

        @Override
        public boolean hasChildren(Object element) {
            Window[] list;
            if (element instanceof IHvDevice && DeviceSelector.this.mDoTreeViewStuff && (list = DeviceSelector.this.mModel.getWindows((IHvDevice)element)) != null) {
                return list.length != 0;
            }
            return false;
        }

        @Override
        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof DeviceSelectionModel) {
                return DeviceSelector.this.mModel.getDevices();
            }
            return new Object[0];
        }

        @Override
        public void dispose() {
        }

        @Override
        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        @Override
        public Image getImage(Object element) {
            if (element instanceof IHvDevice) {
                if (((IHvDevice)element).getDevice().isEmulator()) {
                    return DeviceSelector.this.mEmulatorImage;
                }
                return DeviceSelector.this.mDeviceImage;
            }
            return null;
        }

        @Override
        public String getText(Object element) {
            if (element instanceof IHvDevice) {
                return ((IHvDevice)element).getDevice().getName();
            }
            if (element instanceof Window) {
                return ((Window)element).getTitle();
            }
            return null;
        }

        @Override
        public Font getFont(Object element) {
            int focusedWindow;
            if (element instanceof Window && (focusedWindow = DeviceSelector.this.mModel.getFocusedWindow(((Window)element).getHvDevice())) == ((Window)element).getHashCode()) {
                return DeviceSelector.this.mBoldFont;
            }
            return null;
        }

        @Override
        public void addListener(ILabelProviderListener listener) {
        }

        @Override
        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        @Override
        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

