/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdkuilib.internal.repository.ui;

import com.android.prefs.AndroidLocation;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;

public class ShellSizeAndPos {
    private static final String SETTINGS_FILENAME = "androidwin.cfg";
    private static final String PX = "_px";
    private static final String PY = "_py";
    private static final String SX = "_sx";
    private static final String SY = "_sy";

    public static void loadSizeAndPos(Shell shell, String prefix) {
        Properties props = ShellSizeAndPos.loadProperties();
        try {
            int px = Integer.parseInt(props.getProperty(prefix + PX));
            int py = Integer.parseInt(props.getProperty(prefix + PY));
            int sx = Integer.parseInt(props.getProperty(prefix + SX));
            int sy = Integer.parseInt(props.getProperty(prefix + SY));
            Point p1 = new Point(px, py);
            Point p2 = new Point(px + sx, py + sy);
            Rectangle r = new Rectangle(px, py, sy, sy);
            Monitor bestMatch = null;
            int bestSurface = -1;
            for (Monitor monitor : shell.getDisplay().getMonitors()) {
                Rectangle area = monitor.getClientArea();
                if (area.contains(p1) && area.contains(p2)) {
                    bestMatch = monitor;
                    bestSurface = Integer.MAX_VALUE;
                    break;
                }
                Rectangle i = area.intersection(r);
                int surface = i.width * i.height;
                if (surface <= bestSurface) continue;
                bestSurface = surface;
                bestMatch = monitor;
            }
            if (bestMatch != null && bestSurface != Integer.MAX_VALUE) {
                Rectangle area = bestMatch.getClientArea();
                sx = Math.min(sx, area.width);
                sy = Math.min(sy, area.height);
                px = area.x + (area.width - sx) / 2;
                py = area.y + (area.height - sy) / 2;
            }
            shell.setLocation(px, py);
            shell.setSize(sx, sy);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void saveSizeAndPos(Shell shell, String prefix) {
        Properties props = ShellSizeAndPos.loadProperties();
        Point loc = shell.getLocation();
        Point size = shell.getSize();
        props.setProperty(prefix + PX, Integer.toString(loc.x));
        props.setProperty(prefix + PY, Integer.toString(loc.y));
        props.setProperty(prefix + SX, Integer.toString(size.x));
        props.setProperty(prefix + SY, Integer.toString(size.y));
        ShellSizeAndPos.saveProperties(props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadProperties() {
        Properties props = new Properties();
        FileInputStream fis = null;
        try {
            String folder = AndroidLocation.getFolder();
            File f = new File(folder, SETTINGS_FILENAME);
            if (f.exists()) {
                fis = new FileInputStream(f);
                props.load(fis);
            }
        }
        catch (Exception e) {
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {}
            }
        }
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveProperties(Properties props) {
        FileOutputStream fos = null;
        try {
            String folder = AndroidLocation.getFolder();
            File f = new File(folder, SETTINGS_FILENAME);
            fos = new FileOutputStream(f);
            props.store(fos, "## Size and Pos for SDK Manager Windows");
        }
        catch (Exception e) {
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

