/*
 * Decompiled with CFR 0.152.
 */
package com.android.ant;

import com.android.ant.DependencyHelper;
import java.io.File;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;

public class ComputeProjectClasspathTask
extends Task {
    private String mProjectLocation;
    private String mProjectClassPathOut;

    public void setProjectLocation(String projectLocation) {
        this.mProjectLocation = projectLocation;
    }

    public void setProjectClassPathOut(String projectClassPathOut) {
        this.mProjectClassPathOut = projectClassPathOut;
    }

    public void execute() throws BuildException {
        if (this.mProjectLocation == null) {
            throw new BuildException("Missing attribute projectLocation");
        }
        if (this.mProjectClassPathOut == null) {
            throw new BuildException("Missing attribute projectClassPathOut");
        }
        DependencyHelper helper = new DependencyHelper(new File(this.mProjectLocation), false);
        DependencyHelper.JarProcessor processor = new DependencyHelper.JarProcessor();
        helper.processLibraries(processor);
        List<File> jars = processor.getJars();
        File libsFolder = new File(this.mProjectLocation, "libs");
        File[] jarFiles = libsFolder.listFiles(processor.getFilter());
        if (jarFiles != null) {
            for (File jarFile : jarFiles) {
                jars.add(jarFile);
            }
        }
        jars = helper.sanitizePaths(jars);
        Project antProject = this.getProject();
        System.out.println("Resolved classpath:");
        Path path = new Path(antProject);
        for (File jar : jars) {
            Path.PathElement element = path.createPathElement();
            String p = jar.getAbsolutePath();
            element.setPath(p);
            System.out.println(p);
        }
        File bin = new File(this.mProjectLocation, helper.getOutDir() + File.separator + "classes");
        Path.PathElement element = path.createPathElement();
        String p = bin.getAbsolutePath();
        element.setPath(p);
        System.out.println(p);
        antProject.addReference(this.mProjectClassPathOut, (Object)path);
    }
}

