/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmuilib;

import com.android.ddmlib.ClientData;
import com.android.ddmlib.HeapSegment;
import com.android.ddmuilib.TablePanel;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;

public abstract class BaseHeapPanel
extends TablePanel {
    protected byte[] mProcessedHeapData;
    private Map<Integer, ArrayList<HeapSegment.HeapSegmentElement>> mHeapMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean serializeHeapData(ClientData.HeapData heapData) {
        ClientData.HeapData heapData2 = heapData;
        synchronized (heapData2) {
            Collection<HeapSegment> heapSegments = heapData.getHeapSegments();
            if (heapSegments != null) {
                heapData.clearHeapData();
                this.doSerializeHeapData(heapSegments);
                heapData.setProcessedHeapData(this.mProcessedHeapData);
                heapData.setProcessedHeapMap(this.mHeapMap);
            } else {
                byte[] pixData = heapData.getProcessedHeapData();
                if (pixData == this.mProcessedHeapData) {
                    return false;
                }
                this.mProcessedHeapData = pixData;
                Map<Integer, ArrayList<HeapSegment.HeapSegmentElement>> heapMap = heapData.getProcessedHeapMap();
                this.mHeapMap = heapMap;
            }
        }
        return true;
    }

    protected byte[] getSerializedData() {
        return this.mProcessedHeapData;
    }

    private void doSerializeHeapData(Collection<HeapSegment> heapData) {
        this.mHeapMap = new TreeMap<Integer, ArrayList<HeapSegment.HeapSegmentElement>>();
        ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
        for (HeapSegment hs : heapData) {
            HeapSegment.HeapSegmentElement e = null;
            while ((e = hs.getNextElement(null)) != null) {
                int v = e.getSolidity() == 0 ? 1 : e.getKind() + 2;
                ArrayList<HeapSegment.HeapSegmentElement> elementList = this.mHeapMap.get(v);
                if (elementList == null) {
                    elementList = new ArrayList();
                    this.mHeapMap.put(v, elementList);
                }
                elementList.add(e);
                for (int len = e.getLength() / 8; len > 0; --len) {
                    out.write(v);
                }
            }
        }
        this.mProcessedHeapData = out.toByteArray();
        Collection<ArrayList<HeapSegment.HeapSegmentElement>> elementLists = this.mHeapMap.values();
        for (ArrayList<HeapSegment.HeapSegmentElement> elementList : elementLists) {
            Collections.sort(elementList);
        }
    }

    protected ImageData createLinearHeapImage(byte[] pixData, int h, PaletteData palette) {
        int w = pixData.length / h;
        if (pixData.length % h != 0) {
            ++w;
        }
        ImageData id = new ImageData(w, h, 8, palette);
        int x = 0;
        int y = 0;
        for (byte b : pixData) {
            if (b >= 0) {
                id.setPixel(x, y, (int)b);
            }
            if (++y < h) continue;
            y = 0;
            ++x;
        }
        return id;
    }
}

