/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmuilib.logcat;

import com.android.ddmlib.Log;
import com.android.ddmlib.logcat.LogCatFilter;
import com.android.ddmuilib.logcat.LogCatFilterData;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class LogCatFilterSettingsSerializer {
    private static final char SINGLE_QUOTE = '\'';
    private static final char ESCAPE_CHAR = '\\';
    private static final String ATTR_DELIM = ", ";
    private static final String KW_DELIM = ": ";
    private static final String KW_NAME = "name";
    private static final String KW_TAG = "tag";
    private static final String KW_TEXT = "text";
    private static final String KW_PID = "pid";
    private static final String KW_APP = "app";
    private static final String KW_LOGLEVEL = "level";

    public String encodeToPreferenceString(List<LogCatFilter> filters, Map<LogCatFilter, LogCatFilterData> filterData) {
        StringBuffer sb = new StringBuffer();
        for (LogCatFilter f : filters) {
            LogCatFilterData fd = filterData.get(f);
            if (fd != null && fd.isTransient()) continue;
            sb.append(KW_NAME);
            sb.append(KW_DELIM);
            sb.append(this.quoteString(f.getName()));
            sb.append(ATTR_DELIM);
            sb.append(KW_TAG);
            sb.append(KW_DELIM);
            sb.append(this.quoteString(f.getTag()));
            sb.append(ATTR_DELIM);
            sb.append(KW_TEXT);
            sb.append(KW_DELIM);
            sb.append(this.quoteString(f.getText()));
            sb.append(ATTR_DELIM);
            sb.append(KW_PID);
            sb.append(KW_DELIM);
            sb.append(this.quoteString(f.getPid()));
            sb.append(ATTR_DELIM);
            sb.append(KW_APP);
            sb.append(KW_DELIM);
            sb.append(this.quoteString(f.getAppName()));
            sb.append(ATTR_DELIM);
            sb.append(KW_LOGLEVEL);
            sb.append(KW_DELIM);
            sb.append(this.quoteString(f.getLogLevel().getStringValue()));
            sb.append(ATTR_DELIM);
        }
        return sb.toString();
    }

    public List<LogCatFilter> decodeFromPreferenceString(String pref) {
        ArrayList<LogCatFilter> fs = new ArrayList<LogCatFilter>();
        List<String> kv = this.getKeyValues(pref);
        if (kv.size() == 0) {
            return fs;
        }
        int index = 0;
        while (index < kv.size()) {
            String name = "";
            String tag = "";
            String pid = "";
            String app = "";
            String text = "";
            Log.LogLevel level = Log.LogLevel.VERBOSE;
            assert (kv.get(index).equals(KW_NAME));
            name = kv.get(index + 1);
            index += 2;
            while (index < kv.size() && !kv.get(index).equals(KW_NAME)) {
                String key = kv.get(index);
                String value = kv.get(index + 1);
                index += 2;
                if (key.equals(KW_TAG)) {
                    tag = value;
                    continue;
                }
                if (key.equals(KW_TEXT)) {
                    text = value;
                    continue;
                }
                if (key.equals(KW_PID)) {
                    pid = value;
                    continue;
                }
                if (key.equals(KW_APP)) {
                    app = value;
                    continue;
                }
                if (!key.equals(KW_LOGLEVEL)) continue;
                level = Log.LogLevel.getByString(value);
            }
            fs.add(new LogCatFilter(name, tag, text, pid, app, level));
        }
        return fs;
    }

    private List<String> getKeyValues(String pref) {
        String kw;
        String value;
        ArrayList<String> kv = new ArrayList<String>();
        for (int index = 0; index < pref.length() && (kw = this.getKeyword(pref.substring(index))) != null; index += value.length() + ATTR_DELIM.length()) {
            value = this.getNextString(pref.substring(index += kw.length() + KW_DELIM.length()));
            value = this.unquoteString(value);
            kv.add(kw);
            kv.add(value);
        }
        return kv;
    }

    private String quoteString(String s) {
        return '\'' + s.replace(Character.toString('\''), "\\'") + '\'';
    }

    private String unquoteString(String s) {
        s = s.substring(1, s.length() - 1);
        return s.replace("\\'", Character.toString('\''));
    }

    private String getKeyword(String pref) {
        int kwlen = pref.indexOf(KW_DELIM);
        if (kwlen == -1) {
            return null;
        }
        return pref.substring(0, kwlen);
    }

    private String getNextString(String s) {
        assert (s.charAt(0) == '\'');
        StringBuffer sb = new StringBuffer();
        for (int index = 0; index < s.length(); ++index) {
            sb.append(s.charAt(index));
            if (index > 0 && s.charAt(index) == '\'' && s.charAt(index - 1) != '\\') break;
        }
        return sb.toString();
    }
}

