/*
 * Decompiled with CFR 0.152.
 */
package de.waldheinz.fs.util;

import de.waldheinz.fs.BlockDevice;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.zip.GZIPInputStream;

public final class RamDisk
implements BlockDevice {
    public static final int DEFAULT_SECTOR_SIZE = 512;
    private final int sectorSize;
    private final ByteBuffer data;
    private final int size;
    private boolean closed;

    public static RamDisk readGzipped(InputStream in) throws IOException {
        GZIPInputStream zis = new GZIPInputStream(in);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        int read = zis.read(buffer);
        int total = 0;
        while (read >= 0) {
            total += read;
            bos.write(buffer, 0, read);
            read = zis.read(buffer);
        }
        if (total < 512) {
            throw new IOException("read only " + total + " bytes");
        }
        ByteBuffer bb = ByteBuffer.wrap(bos.toByteArray(), 0, total);
        return new RamDisk(bb, 512);
    }

    private RamDisk(ByteBuffer buffer, int sectorSize) {
        this.size = buffer.limit();
        this.sectorSize = sectorSize;
        this.data = buffer;
        this.closed = false;
    }

    public RamDisk(int size) {
        this(size, 512);
    }

    public RamDisk(int size, int sectorSize) {
        if (sectorSize < 1) {
            throw new IllegalArgumentException("invalid sector size");
        }
        this.sectorSize = sectorSize;
        this.size = size;
        this.data = ByteBuffer.allocate(size);
    }

    @Override
    public long getSize() {
        this.checkClosed();
        return this.size;
    }

    @Override
    public void read(long devOffset, ByteBuffer dest) throws IOException {
        this.checkClosed();
        if (devOffset > this.getSize()) {
            StringBuilder sb = new StringBuilder();
            sb.append("read at ").append(devOffset);
            sb.append(" is off size (").append(this.getSize()).append(")");
            throw new IllegalArgumentException(sb.toString());
        }
        this.data.limit((int)(devOffset + (long)dest.remaining()));
        this.data.position((int)devOffset);
        dest.put(this.data);
    }

    @Override
    public void write(long devOffset, ByteBuffer src) throws IOException {
        this.checkClosed();
        if (devOffset + (long)src.remaining() > this.getSize()) {
            throw new IllegalArgumentException("offset=" + devOffset + ", length=" + src.remaining() + ", size=" + this.getSize());
        }
        this.data.limit((int)(devOffset + (long)src.remaining()));
        this.data.position((int)devOffset);
        this.data.put(src);
    }

    public ByteBuffer getBuffer() {
        return this.data.asReadOnlyBuffer();
    }

    @Override
    public void flush() throws IOException {
        this.checkClosed();
    }

    @Override
    public int getSectorSize() {
        this.checkClosed();
        return this.sectorSize;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    private void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException("device already closed");
        }
    }

    @Override
    public boolean isReadOnly() {
        this.checkClosed();
        return false;
    }
}

